/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.DefaultGraphqlErrorHandler;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import java.util.Objects;

@FunctionalInterface
public interface GraphqlErrorHandler {
    public static GraphqlErrorHandler of() {
        return DefaultGraphqlErrorHandler.INSTANCE;
    }

    @Nullable
    public HttpResponse handle(ServiceRequestContext var1, ExecutionInput var2, ExecutionResult var3, @Nullable Throwable var4);

    default public GraphqlErrorHandler orElse(GraphqlErrorHandler other) {
        Objects.requireNonNull(other, "other");
        if (this == other) {
            return this;
        }
        return (ctx, input, executionResult, cause) -> {
            HttpResponse response = this.handle(ctx, input, executionResult, cause);
            if (response != null) {
                return response;
            }
            return other.handle(ctx, input, executionResult, cause);
        };
    }
}

