/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.websocket.WebSocketCloseStatus;
import com.linecorp.armeria.common.websocket.WebSocketWriter;
import com.linecorp.armeria.internal.common.websocket.WebSocketUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.ExecutionResultSubscriber;
import com.linecorp.armeria.server.graphql.GraphqlExecutor;
import com.linecorp.armeria.server.graphql.GraphqlServiceContexts;
import com.linecorp.armeria.server.graphql.GraphqlSubProtocol;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import io.netty.util.concurrent.EventExecutor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphqlWSSubProtocol {
    private static final Logger logger = LoggerFactory.getLogger(GraphqlWSSubProtocol.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final HashMap<String, ExecutionResultSubscriber> graphqlSubscriptions = new HashMap();
    private static final TypeReference<Map<String, Object>> JSON_MAP = new TypeReference<Map<String, Object>>(){};
    private boolean connectionInitiated;
    private final ServiceRequestContext ctx;
    private final GraphqlExecutor graphqlExecutor;
    private final Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFunction;
    private final Map<String, Object> upgradeCtx;
    private Map<String, Object> connectionCtx = ImmutableMap.of();

    GraphqlWSSubProtocol(ServiceRequestContext ctx, GraphqlExecutor graphqlExecutor, Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFunction) {
        this.ctx = ctx;
        this.graphqlExecutor = graphqlExecutor;
        this.dataLoaderRegistryFunction = dataLoaderRegistryFunction;
        this.upgradeCtx = GraphqlServiceContexts.graphqlContext(ctx);
    }

    @Nullable
    public void handleBinary(WebSocketWriter out) {
        out.close(WebSocketCloseStatus.INVALID_MESSAGE_TYPE, "Binary frames are not supported");
    }

    @Nullable
    public void handleText(String event, WebSocketWriter out) {
        if (!out.isOpen()) {
            return;
        }
        try {
            Map<String, Object> eventMap = GraphqlWSSubProtocol.parseJsonString(event, JSON_MAP);
            String type = GraphqlWSSubProtocol.toStringFromJson(eventMap.get("type"));
            if (type == null) {
                throw new GraphqlWebSocketCloseException(4400, "type is required");
            }
            switch (type) {
                case "connection_init": {
                    if (this.connectionInitiated) {
                        throw new GraphqlWebSocketCloseException(4429, "Already initiated");
                    }
                    Object rawPayload = eventMap.get("payload");
                    if (rawPayload != null) {
                        this.connectionCtx = GraphqlWSSubProtocol.toMapFromJson(rawPayload);
                    }
                    this.connectionInitiated = true;
                    GraphqlWSSubProtocol.writeConnectionAck(out);
                    break;
                }
                case "ping": {
                    GraphqlWSSubProtocol.writePong(out);
                    break;
                }
                case "pong": {
                    break;
                }
                case "subscribe": {
                    this.ensureInitiated();
                    String id = GraphqlWSSubProtocol.toStringFromJson(eventMap.get("id"));
                    if (id == null) {
                        throw new GraphqlWebSocketCloseException(4400, "id is required");
                    }
                    Map<String, Object> payload = GraphqlWSSubProtocol.toMapFromJson(eventMap.get("payload"));
                    try {
                        if (this.graphqlSubscriptions.containsKey(id)) {
                            throw new GraphqlWebSocketCloseException(4409, "Already subscribed");
                        }
                        String operationName = GraphqlWSSubProtocol.toStringFromJson(payload.get("operationName"));
                        String query = GraphqlWSSubProtocol.toStringFromJson(payload.get("query"));
                        Map<String, Object> variables = GraphqlWSSubProtocol.toMapFromJson(payload.get("variables"));
                        Map<String, Object> extensions = GraphqlWSSubProtocol.toMapFromJson(payload.get("extensions"));
                        ExecutionInput executionInput = ExecutionInput.newExecutionInput().graphQLContext(this.connectionCtx).graphQLContext(this.upgradeCtx).query(query).variables(variables).operationName(operationName).extensions(extensions).dataLoaderRegistry(this.dataLoaderRegistryFunction.apply((ServiceRequestContext)this.ctx)).build();
                        CompletableFuture<ExecutionResult> future = this.graphqlExecutor.executeGraphql(this.ctx, executionInput);
                        future.handleAsync((executionResult, throwable) -> {
                            this.handleExecutionResult(out, id, (ExecutionResult)executionResult, (Throwable)throwable);
                            return null;
                        }, (Executor)this.ctx.eventLoop());
                        break;
                    }
                    catch (GraphqlWebSocketCloseException e) {
                        logger.debug("Error handling subscription", (Throwable)e);
                        ExecutionResultSubscriber s = this.graphqlSubscriptions.remove(id);
                        if (s != null) {
                            s.setCompleted();
                        }
                        out.close(e.getWebSocketCloseStatus());
                        break;
                    }
                    catch (Exception e) {
                        logger.debug("Error handling subscription", (Throwable)e);
                        GraphqlWSSubProtocol.writeError(out, id, e);
                        return;
                    }
                }
                case "complete": {
                    this.ensureInitiated();
                    String id = GraphqlWSSubProtocol.toStringFromJson(eventMap.get("id"));
                    if (id == null) {
                        throw new GraphqlWebSocketCloseException(4400, "id is required");
                    }
                    ExecutionResultSubscriber s = this.graphqlSubscriptions.remove(id);
                    if (s != null) {
                        s.setCompleted();
                    }
                    return;
                }
                default: {
                    String reasonPhrase = WebSocketUtil.maybeTruncate((String)("Unknown event type: " + type));
                    assert (reasonPhrase != null);
                    throw new GraphqlWebSocketCloseException(4400, reasonPhrase);
                }
            }
        }
        catch (GraphqlWebSocketCloseException e) {
            logger.debug("Error while handling event", (Throwable)e);
            out.close(e.getWebSocketCloseStatus());
        }
        catch (Exception e) {
            logger.debug("Error while handling event", (Throwable)e);
            out.close((Throwable)e);
        }
    }

    private void handleExecutionResult(final WebSocketWriter out, final String id, @Nullable ExecutionResult executionResult, @Nullable Throwable t) {
        if (t != null) {
            logger.debug("Error handling subscription", t);
            GraphqlWSSubProtocol.writeError(out, id, t);
            return;
        }
        if (executionResult == null) {
            logger.debug("ExecutionResult was null but no error was thrown");
            GraphqlWSSubProtocol.writeError(out, id, new IllegalArgumentException("ExecutionResult was null"));
            return;
        }
        if (!executionResult.getErrors().isEmpty()) {
            try {
                GraphqlWSSubProtocol.writeError(out, id, executionResult.getErrors());
            }
            catch (JsonProcessingException e) {
                logger.warn("Error serializing error event", (Throwable)e);
                out.close((Throwable)e);
            }
            return;
        }
        if (!(executionResult.getData() instanceof Publisher)) {
            GraphqlWSSubProtocol.writeError(out, id, new Exception("Result of operation was not a subscription"));
            return;
        }
        Publisher publisher = (Publisher)executionResult.getData();
        StreamMessage streamMessage = StreamMessage.of((Publisher)publisher);
        ExecutionResultSubscriber executionResultSubscriber = new ExecutionResultSubscriber(id, new GraphqlSubProtocol(){
            boolean completed;

            @Override
            public void sendResult(String operationId, ExecutionResult executionResult) throws JsonProcessingException {
                GraphqlWSSubProtocol.writeNext(out, operationId, executionResult);
            }

            @Override
            public void sendGraphqlErrors(List<GraphQLError> errors) throws JsonProcessingException {
                GraphqlWSSubProtocol.writeError(out, id, errors);
            }

            @Override
            public void completeWithError(Throwable cause) {
                if (this.completed) {
                    return;
                }
                this.completed = true;
                GraphqlWSSubProtocol.writeError(out, id, cause);
                GraphqlWSSubProtocol.this.graphqlSubscriptions.remove(id);
            }

            @Override
            public void complete() {
                if (this.completed) {
                    return;
                }
                this.completed = true;
                GraphqlWSSubProtocol.writeComplete(out, id);
                GraphqlWSSubProtocol.this.graphqlSubscriptions.remove(id);
            }
        });
        this.graphqlSubscriptions.put(id, executionResultSubscriber);
        streamMessage.subscribe((Subscriber)executionResultSubscriber, (EventExecutor)this.ctx.eventLoop());
    }

    void cancel() {
        for (ExecutionResultSubscriber subscriber : this.graphqlSubscriptions.values()) {
            subscriber.setCompleted();
        }
        this.graphqlSubscriptions.clear();
    }

    private void ensureInitiated() throws Exception {
        if (!this.connectionInitiated) {
            throw new GraphqlWebSocketCloseException(4401, "Unauthorized");
        }
    }

    private static String serializeToJson(Object object) throws JsonProcessingException {
        return mapper.writer().writeValueAsString(object);
    }

    @Nullable
    private static String toStringFromJson(@Nullable Object value) throws GraphqlWebSocketCloseException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw new GraphqlWebSocketCloseException(4400, "Expected string value");
    }

    private static Map<String, Object> toMapFromJson(@Nullable Object maybeMap) throws GraphqlWebSocketCloseException {
        if (maybeMap == null) {
            return ImmutableMap.of();
        }
        if (maybeMap instanceof Map) {
            Map map = (Map)maybeMap;
            if (map.isEmpty()) {
                return ImmutableMap.of();
            }
            return Collections.unmodifiableMap((Map)maybeMap);
        }
        throw new GraphqlWebSocketCloseException(4400, "Expected map value");
    }

    private static <T> T parseJsonString(String content, TypeReference<T> typeReference) throws GraphqlWebSocketCloseException {
        try {
            return (T)mapper.readValue(content, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new GraphqlWebSocketCloseException(4400, "Invalid JSON");
        }
    }

    private static void writePong(WebSocketWriter out) {
        out.tryWrite("{\"type\":\"pong\"}");
    }

    private static void writeConnectionAck(WebSocketWriter out) {
        out.tryWrite("{\"type\":\"connection_ack\"}");
    }

    private static void writeNext(WebSocketWriter out, String operationId, ExecutionResult executionResult) throws JsonProcessingException {
        ImmutableMap response = ImmutableMap.of((Object)"id", (Object)operationId, (Object)"type", (Object)"next", (Object)"payload", (Object)executionResult.toSpecification());
        String event = GraphqlWSSubProtocol.serializeToJson(response);
        logger.trace("NEXT: {}", (Object)event);
        out.tryWrite(event);
    }

    private static void writeError(WebSocketWriter out, String operationId, List<GraphQLError> errors) throws JsonProcessingException {
        List errorSpecifications = errors.stream().map(GraphQLError::toSpecification).collect(Collectors.toList());
        ImmutableMap errorResponse = ImmutableMap.of((Object)"type", (Object)"error", (Object)"id", (Object)operationId, (Object)"payload", errorSpecifications);
        String event = GraphqlWSSubProtocol.serializeToJson(errorResponse);
        logger.trace("ERROR: {}", (Object)event);
        out.tryWrite(event);
    }

    private static void writeError(WebSocketWriter out, String operationId, final Throwable t) {
        ImmutableMap errorResponse = ImmutableMap.of((Object)"type", (Object)"error", (Object)"id", (Object)operationId, (Object)"payload", (Object)ImmutableList.of((Object)new GraphQLError(){

            public String getMessage() {
                return t.getMessage();
            }

            public List<SourceLocation> getLocations() {
                return Collections.emptyList();
            }

            public ErrorClassification getErrorType() {
                return ErrorType.DataFetchingException;
            }
        }.toSpecification()));
        try {
            String event = GraphqlWSSubProtocol.serializeToJson(errorResponse);
            logger.trace("ERROR: {}", (Object)event);
            out.tryWrite(event);
        }
        catch (JsonProcessingException e) {
            logger.warn("Error serializing error event", (Throwable)e);
            out.close((Throwable)e);
        }
    }

    private static void writeComplete(WebSocketWriter out, String operationId) {
        out.tryWrite("{\"type\":\"complete\",\"id\":\"" + operationId + "\"}");
    }

    private static final class GraphqlWebSocketCloseException
    extends Exception {
        private static final long serialVersionUID = 1196626539261081709L;
        private final WebSocketCloseStatus webSocketCloseStatus;

        GraphqlWebSocketCloseException(int code, String reason) {
            this.webSocketCloseStatus = WebSocketCloseStatus.ofPrivateUse((int)code, (String)reason);
        }

        WebSocketCloseStatus getWebSocketCloseStatus() {
            return this.webSocketCloseStatus;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

