/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.websocket.WebSocket;
import com.linecorp.armeria.common.websocket.WebSocketWriter;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.graphql.DefaultGraphqlService;
import com.linecorp.armeria.server.graphql.GraphqlExecutor;
import com.linecorp.armeria.server.graphql.GraphqlService;
import com.linecorp.armeria.server.graphql.GraphqlWSSubProtocol;
import com.linecorp.armeria.server.graphql.GraphqlWebSocketSubscriber;
import com.linecorp.armeria.server.websocket.WebSocketProtocolHandler;
import com.linecorp.armeria.server.websocket.WebSocketService;
import com.linecorp.armeria.server.websocket.WebSocketServiceBuilder;
import com.linecorp.armeria.server.websocket.WebSocketServiceHandler;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dataloader.DataLoaderRegistry;
import org.reactivestreams.Subscriber;

final class GraphqlWebSocketService
implements GraphqlService,
WebSocketService,
WebSocketServiceHandler {
    private static final String GRAPHQL_TRANSPORT_WS = "graphql-transport-ws";
    private final WebSocketService delegate;
    private final Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFunction;
    private final GraphqlExecutor graphqlExecutor;

    GraphqlWebSocketService(DefaultGraphqlService graphqlService, Function<? super ServiceRequestContext, ? extends DataLoaderRegistry> dataLoaderRegistryFunction, @Nullable Consumer<WebSocketServiceBuilder> webSocketServiceCustomizer) {
        WebSocketServiceBuilder webSocketServiceBuilder = WebSocketService.builder((WebSocketServiceHandler)this).fallbackService((HttpService)graphqlService).subprotocols(new String[]{GRAPHQL_TRANSPORT_WS}).aggregateContinuation(true);
        if (webSocketServiceCustomizer != null) {
            webSocketServiceCustomizer.accept(webSocketServiceBuilder);
        }
        this.delegate = webSocketServiceBuilder.build();
        this.graphqlExecutor = graphqlService;
        this.dataLoaderRegistryFunction = dataLoaderRegistryFunction;
    }

    public WebSocket serve(ServiceRequestContext ctx, WebSocket in) throws Exception {
        return this.delegate.serve(ctx, in);
    }

    public WebSocketProtocolHandler protocolHandler() {
        return this.delegate.protocolHandler();
    }

    public WebSocket handle(ServiceRequestContext ctx, WebSocket in) {
        WebSocketWriter outgoing = WebSocket.streaming();
        GraphqlWSSubProtocol protocol = new GraphqlWSSubProtocol(ctx, this.graphqlExecutor, this.dataLoaderRegistryFunction);
        in.subscribe((Subscriber)new GraphqlWebSocketSubscriber(protocol, outgoing));
        return outgoing;
    }
}

