/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class StatusMessageEscaper {
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String escape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!StatusMessageEscaper.isEscapingChar(value.charAt(i))) continue;
            return StatusMessageEscaper.doEscape(value.getBytes(StandardCharsets.UTF_8), i);
        }
        return value;
    }

    private static boolean isEscapingChar(char c) {
        return c < ' ' || c >= '~' || c == '%';
    }

    private static boolean isEscapingChar(byte b) {
        return b < 32 || b >= 126 || b == 37;
    }

    private static String doEscape(byte[] valueBytes, int ri) {
        byte[] escapedBytes = new byte[ri + (valueBytes.length - ri) * 3];
        if (ri != 0) {
            System.arraycopy(valueBytes, 0, escapedBytes, 0, ri);
        }
        int wi = ri;
        while (ri < valueBytes.length) {
            byte b = valueBytes[ri];
            if (StatusMessageEscaper.isEscapingChar(b)) {
                escapedBytes[wi] = 37;
                escapedBytes[wi + 1] = HEX[b >> 4 & 0xF];
                escapedBytes[wi + 2] = HEX[b & 0xF];
                wi += 3;
            } else {
                escapedBytes[wi++] = b;
            }
            ++ri;
        }
        byte[] dest = new byte[wi];
        System.arraycopy(escapedBytes, 0, dest, 0, wi);
        return new String(dest, StandardCharsets.US_ASCII);
    }

    public static String unescape(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '~' && (c != '%' || i + 2 >= value.length())) continue;
            return StatusMessageEscaper.doUnescape(value.getBytes(StandardCharsets.US_ASCII));
        }
        return value;
    }

    private static String doUnescape(byte[] value) {
        ByteBuffer buf = ByteBuffer.allocate(value.length);
        int i = 0;
        while (i < value.length) {
            if (value[i] == 37 && i + 2 < value.length) {
                try {
                    buf.put((byte)Integer.parseInt(new String(value, i + 1, 2, StandardCharsets.UTF_8), 16));
                    i += 3;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buf.put(value[i]);
            ++i;
        }
        return new String(buf.array(), 0, buf.position(), StandardCharsets.UTF_8);
    }

    private StatusMessageEscaper() {
    }
}

