/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.grpc.protocol;

import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.unsafe.PooledHttpClient;
import com.linecorp.armeria.client.unsafe.SimplePooledDecoratingHttpClient;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.StatusMessageEscaper;
import com.linecorp.armeria.common.unsafe.PooledAggregatedHttpResponse;
import com.linecorp.armeria.common.unsafe.PooledHttpData;
import com.linecorp.armeria.common.unsafe.PooledHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nullable;

public final class UnaryGrpcClient {
    private final WebClient webClient;

    public UnaryGrpcClient(WebClient webClient) {
        this.webClient = (WebClient)Clients.newDerivedClient((Object)webClient, (ClientOptionValue[])new ClientOptionValue[]{(ClientOptionValue)ClientOption.DECORATION.newValue((Object)ClientDecoration.of(x$0 -> new GrpcFramingDecorator((HttpClient)x$0)))});
    }

    public CompletableFuture<byte[]> execute(String uri, byte[] payload) {
        HttpRequest request = HttpRequest.of((RequestHeaders)RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)uri, (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/grpc+proto", (CharSequence)HttpHeaderNames.TE, (Object)HttpHeaderValues.TRAILERS), (HttpData)HttpData.wrap((byte[])payload));
        return this.webClient.execute(request).aggregate().thenApply(msg -> {
            if (!HttpStatus.OK.equals((Object)msg.status())) {
                throw new ArmeriaStatusException(13, "Non-successful HTTP response code: " + msg.status());
            }
            String grpcStatus = msg.headers().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
            if (grpcStatus != null) {
                UnaryGrpcClient.checkGrpcStatus(grpcStatus, (HttpHeaders)msg.headers());
            } else {
                grpcStatus = msg.trailers().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
                UnaryGrpcClient.checkGrpcStatus(grpcStatus, msg.trailers());
            }
            return msg.content().array();
        });
    }

    private static void checkGrpcStatus(@Nullable String grpcStatus, HttpHeaders headers) {
        if (grpcStatus != null && !"0".equals(grpcStatus)) {
            String grpcMessage = headers.get((CharSequence)GrpcHeaderNames.GRPC_MESSAGE);
            if (grpcMessage != null) {
                grpcMessage = StatusMessageEscaper.unescape(grpcMessage);
            }
            throw new ArmeriaStatusException(Integer.parseInt(grpcStatus), grpcMessage);
        }
    }

    private static final class GrpcFramingDecorator
    extends SimplePooledDecoratingHttpClient {
        private GrpcFramingDecorator(HttpClient delegate) {
            super(delegate);
        }

        public HttpResponse execute(PooledHttpClient client, ClientRequestContext ctx, PooledHttpRequest req) {
            return HttpResponse.from((CompletionStage)((CompletableFuture)req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).thenCompose(msg -> {
                PooledHttpData framed;
                ByteBuf buf = msg.content().content();
                try (ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), Integer.MAX_VALUE);){
                    framed = framer.writePayload(buf);
                }
                try {
                    return client.execute(ctx, PooledHttpRequest.of((HttpRequest)HttpRequest.of((RequestHeaders)req.headers(), (HttpData)framed))).aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc());
                }
                catch (Exception e) {
                    throw new ArmeriaStatusException(13, "Error executing request.");
                }
            })).thenCompose(msg -> {
                if (!msg.status().equals((Object)HttpStatus.OK) || msg.content().isEmpty()) {
                    return CompletableFuture.completedFuture(msg.toHttpResponse());
                }
                final CompletableFuture responseFuture = new CompletableFuture();
                try (ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(new ArmeriaMessageDeframer.Listener((PooledAggregatedHttpResponse)msg){
                    final /* synthetic */ PooledAggregatedHttpResponse val$msg;
                    {
                        this.val$msg = pooledAggregatedHttpResponse;
                    }

                    @Override
                    public void messageRead(ArmeriaMessageDeframer.DeframedMessage unframed) {
                        ByteBuf buf = unframed.buf();
                        assert (buf != null);
                        responseFuture.complete(HttpResponse.of((ResponseHeaders)this.val$msg.headers(), (HttpData)PooledHttpData.wrap((ByteBuf)buf).withEndOfStream(), (HttpHeaders)this.val$msg.trailers()));
                    }

                    @Override
                    public void endOfStream() {
                        if (!responseFuture.isDone()) {
                            responseFuture.complete(HttpResponse.of((ResponseHeaders)this.val$msg.headers(), (HttpData)HttpData.empty(), (HttpHeaders)this.val$msg.trailers()));
                        }
                    }
                }, Integer.MAX_VALUE, ctx.alloc());){
                    deframer.request(1);
                    deframer.deframe((HttpData)msg.content(), true);
                }
                return responseFuture;
            }), (EventExecutor)ctx.eventLoop());
        }
    }
}

