/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.Compressor;
import com.linecorp.armeria.common.unsafe.PooledHttpData;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nullable;

public class ArmeriaMessageFramer
implements AutoCloseable {
    public static final int NO_MAX_OUTBOUND_MESSAGE_SIZE = -1;
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED = 0;
    private static final byte COMPRESSED = 1;
    private final ByteBufAllocator alloc;
    private final int maxOutboundMessageSize;
    private boolean messageCompression = true;
    @Nullable
    private Compressor compressor;
    private boolean closed;

    public ArmeriaMessageFramer(ByteBufAllocator alloc, int maxOutboundMessageSize) {
        this.alloc = Objects.requireNonNull(alloc, "alloc");
        this.maxOutboundMessageSize = maxOutboundMessageSize;
    }

    public PooledHttpData writePayload(ByteBuf message) {
        this.verifyNotClosed();
        boolean compressed = this.messageCompression && this.compressor != null;
        int messageLength = message.readableBytes();
        try {
            ByteBuf buf = messageLength != 0 && compressed ? this.writeCompressed(message) : this.writeUncompressed(message);
            return PooledHttpData.wrap((ByteBuf)buf);
        }
        catch (IOException | RuntimeException e) {
            throw new ArmeriaStatusException(13, "Failed to frame message", e);
        }
    }

    public void setMessageCompression(boolean messageCompression) {
        this.messageCompression = messageCompression;
    }

    public void setCompressor(@Nullable Compressor compressor) {
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf writeCompressed(ByteBuf message) throws IOException {
        assert (this.compressor != null);
        CompositeByteBuf compressed = this.alloc.compositeBuffer();
        try (OutputStream compressingStream = this.compressor.compress((OutputStream)new ByteBufOutputStream((ByteBuf)compressed));){
            compressingStream.write(ByteBufUtil.getBytes((ByteBuf)message));
        }
        finally {
            message.release();
        }
        return this.write((ByteBuf)compressed, true);
    }

    private ByteBuf writeUncompressed(ByteBuf message) {
        return this.write(message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf write(ByteBuf message, boolean compressed) {
        int messageLength = message.readableBytes();
        if (this.maxOutboundMessageSize >= 0 && messageLength > this.maxOutboundMessageSize) {
            message.release();
            throw new ArmeriaStatusException(8, String.format("message too large %d > %d", messageLength, this.maxOutboundMessageSize));
        }
        if (messageLength <= 128) {
            try {
                ByteBuf buf = this.alloc.buffer(5 + messageLength);
                buf.writeByte(compressed ? 1 : 0);
                buf.writeInt(messageLength);
                buf.writeBytes(message);
                ByteBuf byteBuf = buf;
                return byteBuf;
            }
            finally {
                message.release();
            }
        }
        return new CompositeByteBuf(this.alloc, true, 2, new ByteBuf[]{this.alloc.buffer(5).writeByte(compressed ? 1 : 0).writeInt(messageLength), message});
    }

    private void verifyNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"Framer already closed");
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

