/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc.protocol;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcTrailersUtil;
import com.linecorp.armeria.common.unsafe.PooledHttpData;
import com.linecorp.armeria.common.unsafe.PooledHttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.unsafe.AbstractPooledHttpService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class AbstractUnsafeUnaryGrpcService
extends AbstractPooledHttpService {
    private static final ResponseHeaders RESPONSE_HEADERS = ResponseHeaders.of((HttpStatus)HttpStatus.OK, (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/grpc+proto", (CharSequence)GrpcHeaderNames.GRPC_ENCODING, (String)"identity");

    protected abstract CompletableFuture<ByteBuf> handleMessage(ByteBuf var1);

    protected final HttpResponse doPost(ServiceRequestContext ctx, PooledHttpRequest req) {
        CompletionStage responseFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).thenCompose(msg -> AbstractUnsafeUnaryGrpcService.deframeMessage(msg.content(), ctx.alloc()))).thenCompose(this::handleMessage)).thenApply(responseMessage -> {
            ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), Integer.MAX_VALUE);
            PooledHttpData framed = framer.writePayload((ByteBuf)responseMessage);
            return HttpResponse.of((ResponseHeaders)RESPONSE_HEADERS, (HttpData)framed, (HttpHeaders)GrpcTrailersUtil.statusToTrailers(0, null, true).build());
        })).exceptionally(t -> {
            HttpHeadersBuilder trailers;
            if (t instanceof ArmeriaStatusException) {
                ArmeriaStatusException statusException = (ArmeriaStatusException)t;
                trailers = GrpcTrailersUtil.statusToTrailers(statusException.getCode(), statusException.getMessage(), false);
            } else {
                trailers = GrpcTrailersUtil.statusToTrailers(13, t.getMessage(), false);
            }
            return HttpResponse.of((HttpObject[])new HttpObject[]{trailers.build()});
        });
        return HttpResponse.from((CompletionStage)responseFuture);
    }

    private static CompletableFuture<ByteBuf> deframeMessage(PooledHttpData framed, ByteBufAllocator alloc) {
        final CompletableFuture<ByteBuf> deframed = new CompletableFuture<ByteBuf>();
        try (ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(new ArmeriaMessageDeframer.Listener(){

            @Override
            public void messageRead(ArmeriaMessageDeframer.DeframedMessage message) {
                assert (message.buf() != null);
                deframed.complete(message.buf());
            }

            @Override
            public void endOfStream() {
                if (!deframed.isDone()) {
                    deframed.complete(Unpooled.EMPTY_BUFFER);
                }
            }
        }, Integer.MAX_VALUE, alloc);){
            deframer.request(1);
            deframer.deframe((HttpData)framed, true);
        }
        return deframed;
    }
}

