/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc.protocol;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.internal.common.grpc.protocol.GrpcTrailersUtil;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class AbstractUnsafeUnaryGrpcService
extends AbstractHttpService {
    private static final ResponseHeaders RESPONSE_HEADERS = ResponseHeaders.of((HttpStatus)HttpStatus.OK, (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/grpc+proto", (CharSequence)GrpcHeaderNames.GRPC_ENCODING, (String)"identity");

    protected abstract CompletableFuture<ByteBuf> handleMessage(ByteBuf var1);

    protected final HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) {
        CompletionStage responseFuture = ((CompletableFuture)((CompletableFuture)((CompletableFuture)req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).thenCompose(msg -> AbstractUnsafeUnaryGrpcService.deframeMessage(msg.content(), ctx.alloc()))).thenCompose(this::handleMessage)).thenApply(responseMessage -> {
            ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), Integer.MAX_VALUE, false);
            HttpData framed = framer.writePayload((ByteBuf)responseMessage);
            HttpHeadersBuilder trailers = HttpHeaders.builder();
            GrpcTrailersUtil.addStatusMessageToTrailers(trailers, 0, null);
            return HttpResponse.of((ResponseHeaders)RESPONSE_HEADERS, (HttpData)framed, (HttpHeaders)trailers.build());
        })).exceptionally(t -> {
            ResponseHeadersBuilder trailers = RESPONSE_HEADERS.toBuilder();
            if (t instanceof ArmeriaStatusException) {
                ArmeriaStatusException statusException = (ArmeriaStatusException)t;
                GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailers, statusException.getCode(), statusException.getMessage());
            } else {
                GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailers, 13, t.getMessage());
            }
            return HttpResponse.of((HttpObject[])new HttpObject[]{trailers.build()});
        });
        return HttpResponse.from((CompletionStage)responseFuture);
    }

    private static CompletableFuture<ByteBuf> deframeMessage(HttpData framed, ByteBufAllocator alloc) {
        final CompletableFuture<ByteBuf> deframed = new CompletableFuture<ByteBuf>();
        try (ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(new ArmeriaMessageDeframer.Listener(){

            @Override
            public void messageRead(ArmeriaMessageDeframer.DeframedMessage message) {
                assert (message.buf() != null);
                deframed.complete(message.buf());
            }

            @Override
            public void endOfStream() {
                if (!deframed.isDone()) {
                    deframed.complete(Unpooled.EMPTY_BUFFER);
                }
            }
        }, Integer.MAX_VALUE, alloc, false);){
            deframer.request(1);
            deframer.deframe(framed, true);
        }
        return deframed;
    }
}

