/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.Compressor;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.handler.codec.base64.Base64;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class ArmeriaMessageFramer
implements AutoCloseable {
    public static final int NO_MAX_OUTBOUND_MESSAGE_SIZE = -1;
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED = 0;
    private static final byte COMPRESSED = 1;
    @VisibleForTesting
    static final byte UNCOMPRESSED_TRAILERS = -128;
    @VisibleForTesting
    static final byte COMPRESSED_TRAILERS = -127;
    private final ByteBufAllocator alloc;
    private final int maxOutboundMessageSize;
    private final boolean encodeBase64;
    private boolean messageCompression = true;
    @Nullable
    private Compressor compressor;
    private boolean closed;

    public ArmeriaMessageFramer(ByteBufAllocator alloc, int maxOutboundMessageSize, boolean encodeBase64) {
        this.alloc = Objects.requireNonNull(alloc, "alloc");
        this.maxOutboundMessageSize = maxOutboundMessageSize;
        this.encodeBase64 = encodeBase64;
    }

    public HttpData writePayload(ByteBuf message) {
        return this.writePayload(message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpData writePayload(ByteBuf message, boolean webTrailers) {
        this.verifyNotClosed();
        boolean compressed = this.messageCompression && this.compressor != null;
        int messageLength = message.readableBytes();
        try {
            ByteBuf maybeEncodedBuf;
            ByteBuf buf = messageLength != 0 && compressed ? this.writeCompressed(message, webTrailers) : this.writeUncompressed(message, webTrailers);
            if (this.encodeBase64) {
                try {
                    maybeEncodedBuf = Base64.encode((ByteBuf)buf, (boolean)false);
                }
                finally {
                    buf.release();
                }
                int length = maybeEncodedBuf.readableBytes();
                if (this.maxOutboundMessageSize >= 0 && length > this.maxOutboundMessageSize) {
                    maybeEncodedBuf.release();
                    throw this.newMessageTooLargeException(length);
                }
            } else {
                maybeEncodedBuf = buf;
            }
            return HttpData.wrap((ByteBuf)maybeEncodedBuf).withEndOfStream(webTrailers);
        }
        catch (ArmeriaStatusException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new ArmeriaStatusException(13, "Failed to frame message", e);
        }
    }

    public void setMessageCompression(boolean messageCompression) {
        this.messageCompression = messageCompression;
    }

    public void setCompressor(@Nullable Compressor compressor) {
        this.compressor = compressor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf writeCompressed(ByteBuf message, boolean webTrailers) throws IOException {
        assert (this.compressor != null);
        ByteBuf compressed = this.alloc.buffer(message.readableBytes());
        try (OutputStream compressingStream = this.compressor.compress((OutputStream)new ByteBufOutputStream(compressed));){
            compressingStream.write(ByteBufUtil.getBytes((ByteBuf)message));
        }
        finally {
            message.release();
        }
        return this.write(compressed, true, webTrailers);
    }

    private ByteBuf writeUncompressed(ByteBuf message, boolean webTrailers) {
        return this.write(message, false, webTrailers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf write(ByteBuf message, boolean compressed, boolean webTrailers) {
        int flag;
        int messageLength = message.readableBytes();
        if (this.maxOutboundMessageSize >= 0 && messageLength > this.maxOutboundMessageSize) {
            message.release();
            throw this.newMessageTooLargeException(messageLength);
        }
        if (webTrailers) {
            flag = compressed ? -127 : -128;
        } else {
            int n = flag = compressed ? 1 : 0;
        }
        if (messageLength <= 128) {
            try {
                ByteBuf buf = this.alloc.buffer(5 + messageLength);
                buf.writeByte(flag);
                buf.writeInt(messageLength);
                buf.writeBytes(message);
                ByteBuf byteBuf = buf;
                return byteBuf;
            }
            finally {
                message.release();
            }
        }
        return new CompositeByteBuf(this.alloc, true, 2, new ByteBuf[]{this.alloc.buffer(5).writeByte(flag).writeInt(messageLength), message});
    }

    private ArmeriaStatusException newMessageTooLargeException(int messageLength) {
        return new ArmeriaStatusException(8, String.format("message too large %d > %d", messageLength, this.maxOutboundMessageSize));
    }

    private void verifyNotClosed() {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0, (Object)"Framer already closed");
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

