/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.grpc.protocol;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcWebTrailers;
import com.linecorp.armeria.common.grpc.protocol.StatusMessageEscaper;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.internal.client.grpc.protocol.InternalGrpcWebUtil;
import com.linecorp.armeria.internal.common.grpc.protocol.Base64DecoderUtil;
import com.linecorp.armeria.internal.common.grpc.protocol.UnaryGrpcSerializationFormats;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.concurrent.EventExecutor;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnaryGrpcClient {
    private static final Set<SerializationFormat> SUPPORTED_SERIALIZATION_FORMATS = UnaryGrpcSerializationFormats.values();
    private final SerializationFormat serializationFormat;
    private final WebClient webClient;
    private static final Logger logger = LoggerFactory.getLogger(UnaryGrpcClient.class);

    @Deprecated
    public UnaryGrpcClient(WebClient webClient) {
        this(webClient, UnaryGrpcSerializationFormats.PROTO);
    }

    @Deprecated
    public UnaryGrpcClient(WebClient webClient, SerializationFormat serializationFormat) {
        if (!SUPPORTED_SERIALIZATION_FORMATS.contains(serializationFormat)) {
            throw new IllegalArgumentException("serializationFormat: " + serializationFormat + " (expected: one of " + SUPPORTED_SERIALIZATION_FORMATS + ')');
        }
        this.serializationFormat = serializationFormat;
        this.webClient = (WebClient)Clients.newDerivedClient((Object)webClient, (ClientOptionValue[])new ClientOptionValue[]{(ClientOptionValue)ClientOptions.DECORATION.newValue((Object)ClientDecoration.of(delegate -> new GrpcFramingDecorator((HttpClient)delegate, serializationFormat)))});
    }

    public CompletableFuture<byte[]> execute(String uri, byte[] payload) {
        HttpRequest request = HttpRequest.of((RequestHeaders)RequestHeaders.builder((HttpMethod)HttpMethod.POST, (String)uri).contentType(this.serializationFormat.mediaType()).add((CharSequence)HttpHeaderNames.TE, HttpHeaderValues.TRAILERS.toString()).build(), (HttpData)HttpData.wrap((byte[])payload));
        return this.webClient.execute(request).aggregateWithPooledObjects((ByteBufAllocator)PooledByteBufAllocator.DEFAULT).thenApply(msg -> {
            try (HttpData content = msg.content();){
                if (msg.status() != HttpStatus.OK) {
                    throw new ArmeriaStatusException(13, "Non-successful HTTP response code: " + msg.status());
                }
                String grpcStatus = msg.headers().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
                if (grpcStatus != null) {
                    UnaryGrpcClient.checkGrpcStatus(grpcStatus, (HttpHeaders)msg.headers());
                } else {
                    grpcStatus = msg.trailers().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
                    UnaryGrpcClient.checkGrpcStatus(grpcStatus, msg.trailers());
                }
                byte[] byArray = content.array();
                return byArray;
            }
        });
    }

    private static void checkGrpcStatus(@Nullable String grpcStatus, HttpHeaders headers) {
        if (grpcStatus != null && !"0".equals(grpcStatus)) {
            String grpcMessage = headers.get((CharSequence)GrpcHeaderNames.GRPC_MESSAGE);
            if (grpcMessage != null) {
                grpcMessage = StatusMessageEscaper.unescape(grpcMessage);
            }
            throw new ArmeriaStatusException(Integer.parseInt(grpcStatus), grpcMessage);
        }
    }

    private static final class GrpcFramingDecorator
    extends SimpleDecoratingHttpClient {
        private final SerializationFormat serializationFormat;
        private final boolean isGrpcWebText;

        private GrpcFramingDecorator(HttpClient delegate, SerializationFormat serializationFormat) {
            super(delegate);
            this.serializationFormat = serializationFormat;
            this.isGrpcWebText = UnaryGrpcSerializationFormats.isGrpcWebText(serializationFormat);
        }

        public HttpResponse execute(ClientRequestContext ctx, HttpRequest req) {
            return HttpResponse.from((CompletionStage)((CompletableFuture)req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).thenCompose(msg -> {
                try (HttpData content = msg.content();){
                    HttpData framed;
                    ByteBuf buf = content.byteBuf();
                    try (Object framer = new ArmeriaMessageFramer(ctx.alloc(), Integer.MAX_VALUE, this.isGrpcWebText);){
                        framed = ((ArmeriaMessageFramer)framer).writePayload(buf);
                    }
                    try {
                        framer = ((HttpResponse)((Client)this.unwrap()).execute(ctx, (Request)HttpRequest.of((RequestHeaders)req.headers(), (HttpData)framed))).aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc());
                        return framer;
                    }
                    catch (Exception e) {
                        throw new ArmeriaStatusException(13, "Error executing request.");
                    }
                }
            })).thenCompose(msg -> {
                if (msg.status() != HttpStatus.OK || msg.content().isEmpty()) {
                    if (msg.headers().get((CharSequence)GrpcHeaderNames.GRPC_STATUS) != null) {
                        GrpcWebTrailers.set((RequestContext)ctx, (HttpHeaders)msg.headers());
                    } else {
                        GrpcWebTrailers.set((RequestContext)ctx, msg.trailers());
                    }
                    return CompletableFuture.completedFuture(msg.toHttpResponse());
                }
                CompletableFuture responseFuture = new CompletableFuture();
                ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(Integer.MAX_VALUE);
                msg.toHttpResponse().decode((HttpDecoder)deframer, ctx.alloc(), Base64DecoderUtil.byteBufConverter(ctx.alloc(), this.isGrpcWebText)).subscribe((Subscriber)new DeframedMessageSubscriber(ctx, (AggregatedHttpResponse)msg, this.serializationFormat, responseFuture), (EventExecutor)ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS});
                return responseFuture;
            }), (EventExecutor)ctx.eventLoop());
        }
    }

    private static final class DeframedMessageSubscriber
    implements Subscriber<DeframedMessage> {
        private final ClientRequestContext ctx;
        private final AggregatedHttpResponse response;
        private final SerializationFormat serializationFormat;
        private final CompletableFuture<HttpResponse> responseFuture;
        private final boolean isGrpcWeb;
        private HttpData content = HttpData.empty();
        @Nullable
        private HttpHeaders trailers;
        @Nullable
        private Subscription subscription;
        private boolean completed;
        private int processedMessages;

        private DeframedMessageSubscriber(ClientRequestContext ctx, AggregatedHttpResponse response, SerializationFormat serializationFormat, CompletableFuture<HttpResponse> responseFuture) {
            this.ctx = ctx;
            this.response = response;
            this.serializationFormat = serializationFormat;
            this.responseFuture = responseFuture;
            this.isGrpcWeb = UnaryGrpcSerializationFormats.isGrpcWeb(serializationFormat);
        }

        public void onSubscribe(Subscription s) {
            if (this.subscription != null) {
                logger.error("onSubscribe was called multiple times");
                s.cancel();
                return;
            }
            this.subscription = s;
            s.request(2L);
        }

        public void onNext(DeframedMessage message) {
            try {
                if (this.completed) {
                    return;
                }
                this.process(message);
            }
            finally {
                message.close();
            }
        }

        public void onError(Throwable t) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            this.completeExceptionally(t);
        }

        public void onComplete() {
            if (this.completed) {
                return;
            }
            this.completed = true;
            if (this.trailers == null) {
                this.trailers = this.response.trailers();
            }
            GrpcWebTrailers.set((RequestContext)this.ctx, this.trailers);
            this.responseFuture.complete(HttpResponse.of((ResponseHeaders)this.response.headers(), (HttpData)this.content, (HttpHeaders)this.trailers));
        }

        private void process(DeframedMessage message) {
            ByteBuf buf = message.buf();
            if (buf == null) {
                this.cancel(new ArmeriaStatusException(13, "received compressed message; UnaryGrpcClient does not support compression."));
                return;
            }
            if (this.isGrpcWeb && message.isTrailer()) {
                this.trailers = InternalGrpcWebUtil.parseGrpcWebTrailers(buf);
                if (this.trailers == null) {
                    this.cancel(new ArmeriaStatusException(13, String.format("%s trailers malformed: %s", this.serializationFormat.uriText(), buf.toString(StandardCharsets.UTF_8))));
                }
                ++this.processedMessages;
                return;
            }
            if (this.processedMessages > 0) {
                this.cancel(new ArmeriaStatusException(13, "received more than one data message; UnaryGrpcClient does not support streaming."));
                return;
            }
            buf.retain();
            this.content = HttpData.wrap((ByteBuf)buf);
            ++this.processedMessages;
        }

        private void cancel(Throwable t) {
            if (this.completed) {
                return;
            }
            this.completed = true;
            if (this.subscription == null) {
                logger.error("subscriber has no active subscription");
            } else {
                this.subscription.cancel();
            }
            this.completeExceptionally(t);
        }

        private void completeExceptionally(Throwable t) {
            this.content.close();
            this.responseFuture.completeExceptionally(t);
        }
    }
}

