/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.Decompressor;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.StreamDecoderInput;
import com.linecorp.armeria.common.stream.StreamDecoderOutput;
import com.linecorp.armeria.internal.common.grpc.protocol.Base64Decoder;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ArmeriaMessageDeframer
implements HttpDecoder<DeframedMessage> {
    public static final int NO_MAX_INBOUND_MESSAGE_SIZE = -1;
    private static final String DEBUG_STRING = ArmeriaMessageDeframer.class.getName();
    private static final int HEADER_LENGTH = 5;
    private static final int COMPRESSED_FLAG_MASK = 1;
    private static final int RESERVED_MASK = 126;
    private static final int UNINITIALIZED_TYPE = -1;
    private final int maxMessageLength;
    @Nullable
    private final Base64Decoder base64Decoder;
    private int currentType = -1;
    private int requiredLength = 5;
    private boolean startedDeframing;
    @Nullable
    private Decompressor decompressor;

    public ArmeriaMessageDeframer(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength > 0 ? maxMessageLength : Integer.MAX_VALUE;
        this.base64Decoder = null;
    }

    public ArmeriaMessageDeframer(int maxMessageLength, ByteBufAllocator alloc, boolean grpcWebText) {
        this.maxMessageLength = maxMessageLength > 0 ? maxMessageLength : Integer.MAX_VALUE;
        Objects.requireNonNull(alloc, "alloc");
        this.base64Decoder = grpcWebText ? new Base64Decoder(alloc) : null;
    }

    public ByteBuf toByteBuf(HttpData in) {
        if (this.base64Decoder != null) {
            return this.base64Decoder.decode(in.byteBuf());
        }
        return in.byteBuf();
    }

    public void process(StreamDecoderInput in, StreamDecoderOutput<DeframedMessage> out) throws Exception {
        int length;
        this.startedDeframing = true;
        for (int readableBytes = in.readableBytes(); readableBytes >= this.requiredLength; readableBytes -= length) {
            length = this.requiredLength;
            if (this.currentType == -1) {
                this.readHeader(in);
                continue;
            }
            out.add((Object)this.readBody(in));
        }
    }

    private void readHeader(StreamDecoderInput in) {
        short type = in.readUnsignedByte();
        if ((type & 0x7E) != 0) {
            throw new ArmeriaStatusException(13, DEBUG_STRING + ": Frame header malformed: reserved bits not zero");
        }
        this.requiredLength = in.readInt();
        if (this.requiredLength < 0 || this.requiredLength > this.maxMessageLength) {
            throw new ArmeriaStatusException(8, String.format("%s: Frame size %d exceeds maximum: %d. ", DEBUG_STRING, this.requiredLength, this.maxMessageLength));
        }
        this.currentType = type;
    }

    private DeframedMessage readBody(StreamDecoderInput in) {
        ByteBuf buf = this.requiredLength == 0 ? Unpooled.EMPTY_BUFFER : in.readBytes(this.requiredLength);
        boolean isCompressed = (this.currentType & 1) != 0;
        DeframedMessage msg = isCompressed ? this.getCompressedBody(buf) : this.getUncompressedBody(buf);
        this.currentType = -1;
        this.requiredLength = 5;
        return msg;
    }

    private DeframedMessage getUncompressedBody(ByteBuf buf) {
        return new DeframedMessage(buf, this.currentType);
    }

    private DeframedMessage getCompressedBody(ByteBuf buf) {
        if (this.decompressor == null) {
            buf.release();
            throw new ArmeriaStatusException(13, DEBUG_STRING + ": Can't decode compressed frame as compression not configured.");
        }
        try {
            InputStream unlimitedStream = this.decompressor.decompress((InputStream)new ByteBufInputStream(buf, true));
            return new DeframedMessage(new SizeEnforcingInputStream(unlimitedStream, this.maxMessageLength, DEBUG_STRING), this.currentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ArmeriaMessageDeframer decompressor(@Nullable Decompressor decompressor) {
        Preconditions.checkState((!this.startedDeframing ? 1 : 0) != 0, (Object)"Deframing has already started, cannot change decompressor mid-stream.");
        this.decompressor = decompressor;
        return this;
    }

    @VisibleForTesting
    static final class SizeEnforcingInputStream
    extends FilterInputStream {
        private final int maxMessageSize;
        private final String debugString;
        private long maxCount;
        private long count;
        private long mark = -1L;

        SizeEnforcingInputStream(InputStream in, int maxMessageSize, String debugString) {
            super(in);
            this.maxMessageSize = maxMessageSize;
            this.debugString = debugString;
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result != -1) {
                ++this.count;
            }
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result != -1) {
                this.count += (long)result;
            }
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            long result = this.in.skip(n);
            this.count += result;
            this.verifySize();
            this.reportCount();
            return result;
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
            this.mark = this.count;
        }

        @Override
        public synchronized void reset() throws IOException {
            if (!this.in.markSupported()) {
                throw new IOException("Mark not supported");
            }
            if (this.mark == -1L) {
                throw new IOException("Mark not set");
            }
            this.in.reset();
            this.count = this.mark;
        }

        private void reportCount() {
            if (this.count > this.maxCount) {
                this.maxCount = this.count;
            }
        }

        private void verifySize() {
            if (this.count > (long)this.maxMessageSize) {
                throw new ArmeriaStatusException(8, String.format("%s: Compressed frame exceeds maximum frame size: %d. Bytes read: %d. ", this.debugString, this.maxMessageSize, this.count));
            }
        }
    }
}

