/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc.protocol;

import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcWebTrailers;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.grpc.protocol.GrpcTrailersUtil;
import com.linecorp.armeria.internal.common.grpc.protocol.UnaryGrpcSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.EventExecutor;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractUnsafeUnaryGrpcService
extends AbstractHttpService {
    private static final Set<SerializationFormat> SUPPORTED_SERIALIZATION_FORMATS = UnaryGrpcSerializationFormats.values();
    private static final Map<SerializationFormat, ResponseHeaders> RESPONSE_HEADERS_MAP = (Map)SUPPORTED_SERIALIZATION_FORMATS.stream().collect(ImmutableMap.toImmutableMap(f -> f, f -> ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(f.mediaType()).add((CharSequence)GrpcHeaderNames.GRPC_ENCODING, "identity").build()));

    protected abstract CompletionStage<ByteBuf> handleMessage(ServiceRequestContext var1, ByteBuf var2);

    @Nullable
    private static SerializationFormat resolveSerializationFormat(HttpRequest req) {
        MediaType contentType = req.contentType();
        if (contentType == null) {
            return null;
        }
        for (SerializationFormat format : SUPPORTED_SERIALIZATION_FORMATS) {
            if (!format.isAccepted(contentType)) continue;
            return format;
        }
        return null;
    }

    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.UNARY;
    }

    protected final HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) {
        CompletableFuture<ByteBuf> deframed = new CompletableFuture<ByteBuf>();
        SerializationFormat serializationFormat = AbstractUnsafeUnaryGrpcService.resolveSerializationFormat(req);
        if (serializationFormat == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Missing or invalid Content-Type header.");
        }
        boolean isGrpcWebText = UnaryGrpcSerializationFormats.isGrpcWebText(serializationFormat);
        ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(Integer.MAX_VALUE, ctx.alloc(), isGrpcWebText);
        req.decode((HttpDecoder)deframer, ctx.alloc()).subscribe(AbstractUnsafeUnaryGrpcService.singleSubscriber(deframed), (EventExecutor)ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS});
        CompletionStage responseFuture = ((CompletableFuture)deframed.thenCompose(requestMessage -> {
            try (SafeCloseable ignored = ctx.push();){
                CompletionStage<ByteBuf> completionStage = this.handleMessage(ctx, (ByteBuf)requestMessage);
                return completionStage;
            }
        })).handle((responseMessage, cause) -> {
            if (cause == null) {
                try {
                    HttpHeadersBuilder trailersBuilder = HttpHeaders.builder();
                    GrpcTrailersUtil.addStatusMessageToTrailers(trailersBuilder, 0, null);
                    HttpHeaders trailers = trailersBuilder.build();
                    GrpcWebTrailers.set((RequestContext)ctx, trailers);
                    ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), Integer.MAX_VALUE, isGrpcWebText);
                    HttpData content = framer.writePayload((ByteBuf)responseMessage);
                    ResponseHeaders responseHeaders = RESPONSE_HEADERS_MAP.get(serializationFormat);
                    if (UnaryGrpcSerializationFormats.isGrpcWeb(serializationFormat)) {
                        HttpData serializedTrailers = framer.writePayload(GrpcTrailersUtil.serializeTrailersAsMessage(ctx.alloc(), trailers), true);
                        return HttpResponse.of((HttpObject[])new HttpObject[]{responseHeaders, content, serializedTrailers});
                    }
                    return HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)content, (HttpHeaders)trailers);
                }
                catch (Throwable t) {
                    cause = t;
                }
            }
            cause = Exceptions.peel((Throwable)cause);
            ResponseHeadersBuilder trailersBuilder = ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(serializationFormat.mediaType());
            if (cause instanceof ArmeriaStatusException) {
                ArmeriaStatusException statusException = (ArmeriaStatusException)cause;
                GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailersBuilder, statusException.getCode(), statusException.getMessage());
            } else {
                GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailersBuilder, 13, cause.getMessage());
            }
            ResponseHeaders trailers = trailersBuilder.build();
            GrpcWebTrailers.set((RequestContext)ctx, (HttpHeaders)trailers);
            return HttpResponse.of((ResponseHeaders)trailers);
        });
        return HttpResponse.from((CompletableFuture)responseFuture);
    }

    private static Subscriber<DeframedMessage> singleSubscriber(final CompletableFuture<ByteBuf> deframed) {
        return new Subscriber<DeframedMessage>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(DeframedMessage message) {
                deframed.complete(message.buf());
            }

            public void onError(Throwable t) {
                deframed.completeExceptionally(t);
            }

            public void onComplete() {
                if (!deframed.isDone()) {
                    deframed.complete(Unpooled.EMPTY_BUFFER);
                }
            }
        };
    }
}

