/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc.protocol;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.StatusMessageEscaper;
import com.linecorp.armeria.internal.common.util.StringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import java.util.Map;
import javax.annotation.Nullable;

public final class GrpcTrailersUtil {
    public static void addStatusMessageToTrailers(HttpHeadersBuilder trailersBuilder, int code, @Nullable String message) {
        trailersBuilder.endOfStream(true);
        trailersBuilder.add((CharSequence)GrpcHeaderNames.GRPC_STATUS, StringUtil.toString((int)code));
        if (message != null) {
            trailersBuilder.add((CharSequence)GrpcHeaderNames.GRPC_MESSAGE, StatusMessageEscaper.escape(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf serializeTrailersAsMessage(ByteBufAllocator alloc, HttpHeaders trailers) {
        ByteBuf serialized = alloc.buffer();
        boolean success = false;
        try {
            for (Map.Entry trailer : trailers) {
                GrpcTrailersUtil.encodeHeader((CharSequence)trailer.getKey(), (CharSequence)trailer.getValue(), serialized);
            }
            success = true;
        }
        finally {
            if (!success) {
                serialized.release();
            }
        }
        return serialized;
    }

    private static void encodeHeader(CharSequence name, CharSequence value, ByteBuf buf) {
        int nameLen = name.length();
        int valueLen = value.length();
        int entryLen = nameLen + valueLen + 4;
        buf.ensureWritable(entryLen);
        int offset = buf.writerIndex();
        GrpcTrailersUtil.writeAscii(buf, offset, name, nameLen);
        offset += nameLen;
        buf.setByte(offset++, 58);
        buf.setByte(offset++, 32);
        GrpcTrailersUtil.writeAscii(buf, offset, value, valueLen);
        offset += valueLen;
        buf.setByte(offset++, 13);
        buf.setByte(offset++, 10);
        buf.writerIndex(offset);
    }

    private static void writeAscii(ByteBuf buf, int offset, CharSequence value, int valueLen) {
        if (value instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)((AsciiString)value), (int)0, (ByteBuf)buf, (int)offset, (int)valueLen);
        } else {
            GrpcTrailersUtil.writeCharSequence(buf, offset, value, valueLen);
        }
    }

    private static void writeCharSequence(ByteBuf buf, int offset, CharSequence value, int valueLen) {
        for (int i = 0; i < valueLen; ++i) {
            buf.setByte(offset++, (int)AsciiString.c2b((char)value.charAt(i)));
        }
    }

    private GrpcTrailersUtil() {
    }
}

