/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc.protocol;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.grpc.protocol.GrpcTrailersUtil;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class AbstractUnsafeUnaryGrpcService
extends AbstractHttpService {
    private static final ResponseHeaders RESPONSE_HEADERS = ResponseHeaders.of((HttpStatus)HttpStatus.OK, (CharSequence)HttpHeaderNames.CONTENT_TYPE, (String)"application/grpc+proto", (CharSequence)GrpcHeaderNames.GRPC_ENCODING, (String)"identity");

    protected abstract CompletionStage<ByteBuf> handleMessage(ServiceRequestContext var1, ByteBuf var2);

    protected final HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) {
        CompletableFuture<ByteBuf> deframed = new CompletableFuture<ByteBuf>();
        ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(Integer.MAX_VALUE);
        req.decode((HttpDecoder)deframer, ctx.alloc()).subscribe(AbstractUnsafeUnaryGrpcService.singleSubscriber(deframed), (EventExecutor)ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS});
        CompletionStage responseFuture = ((CompletableFuture)((CompletableFuture)deframed.thenCompose(requestMessage -> {
            try (SafeCloseable ignored = ctx.push();){
                CompletionStage<ByteBuf> completionStage = this.handleMessage(ctx, (ByteBuf)requestMessage);
                return completionStage;
            }
        })).thenApply(responseMessage -> {
            ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), Integer.MAX_VALUE, false);
            HttpData framed = framer.writePayload((ByteBuf)responseMessage);
            HttpHeadersBuilder trailers = HttpHeaders.builder();
            GrpcTrailersUtil.addStatusMessageToTrailers(trailers, 0, null);
            return HttpResponse.of((ResponseHeaders)RESPONSE_HEADERS, (HttpData)framed, (HttpHeaders)trailers.build());
        })).exceptionally(t -> {
            ResponseHeadersBuilder trailers = RESPONSE_HEADERS.toBuilder();
            if (t instanceof ArmeriaStatusException) {
                ArmeriaStatusException statusException = (ArmeriaStatusException)t;
                GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailers, statusException.getCode(), statusException.getMessage());
            } else {
                GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailers, 13, t.getMessage());
            }
            return HttpResponse.of((ResponseHeaders)trailers.build());
        });
        return HttpResponse.from((CompletionStage)responseFuture);
    }

    private static Subscriber<DeframedMessage> singleSubscriber(final CompletableFuture<ByteBuf> deframed) {
        return new Subscriber<DeframedMessage>(){

            public void onSubscribe(Subscription s) {
                s.request(1L);
            }

            public void onNext(DeframedMessage message) {
                deframed.complete(message.buf());
            }

            public void onError(Throwable t) {
                deframed.completeExceptionally(t);
            }

            public void onComplete() {
                if (!deframed.isDone()) {
                    deframed.complete(Unpooled.EMPTY_BUFFER);
                }
            }
        };
    }
}

