/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DefaultClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.grpc.GrpcClientOptions;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.common.util.Unwrappable;
import com.linecorp.armeria.internal.client.grpc.ArmeriaClientCall;
import com.linecorp.armeria.internal.client.grpc.CallCredentialsDecoratingClient;
import com.linecorp.armeria.internal.shaded.guava.primitives.Ints;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.MethodDescriptor;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.net.URI;
import javax.annotation.Nullable;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

final class ArmeriaChannel
extends Channel
implements ClientBuilderParams,
Unwrappable {
    private final ClientBuilderParams params;
    private final HttpClient httpClient;
    private final MeterRegistry meterRegistry;
    private final SessionProtocol sessionProtocol;
    private final SerializationFormat serializationFormat;
    @Nullable
    private final MessageMarshaller jsonMarshaller;
    private final String advertisedEncodingsHeader;

    ArmeriaChannel(ClientBuilderParams params, HttpClient httpClient, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, SerializationFormat serializationFormat, @Nullable MessageMarshaller jsonMarshaller) {
        this.params = params;
        this.httpClient = httpClient;
        this.meterRegistry = meterRegistry;
        this.sessionProtocol = sessionProtocol;
        this.serializationFormat = serializationFormat;
        this.jsonMarshaller = jsonMarshaller;
        this.advertisedEncodingsHeader = String.join((CharSequence)",", DecompressorRegistry.getDefaultInstance().getAdvertisedMessageEncodings());
    }

    public <I, O> ClientCall<I, O> newCall(MethodDescriptor<I, O> method, CallOptions callOptions) {
        HttpRequestWriter req = HttpRequest.streaming((RequestHeaders)RequestHeaders.of((HttpMethod)HttpMethod.POST, (String)(this.uri().getPath() + method.getFullMethodName()), (CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.serializationFormat.mediaType(), (CharSequence)HttpHeaderNames.TE, (Object)HttpHeaderValues.TRAILERS));
        DefaultClientRequestContext ctx = this.newContext(HttpMethod.POST, (HttpRequest)req);
        ctx.logBuilder().name(method.getFullMethodName());
        ctx.logBuilder().serializationFormat(this.serializationFormat);
        ctx.logBuilder().deferRequestContent();
        ctx.logBuilder().deferResponseContent();
        ClientOptions options = this.options();
        int maxOutboundMessageSizeBytes = (Integer)options.get(GrpcClientOptions.MAX_OUTBOUND_MESSAGE_SIZE_BYTES);
        int maxInboundMessageSizeBytes = (Integer)options.get(GrpcClientOptions.MAX_INBOUND_MESSAGE_SIZE_BYTES);
        boolean unsafeWrapResponseBuffers = (Boolean)options.get(GrpcClientOptions.UNSAFE_WRAP_RESPONSE_BUFFERS);
        CallCredentials credentials = callOptions.getCredentials();
        Object client = credentials != null ? new CallCredentialsDecoratingClient(this.httpClient, credentials, method, this.authority()) : this.httpClient;
        return new ArmeriaClientCall<I, O>(ctx, this.params.endpointGroup(), (HttpClient)client, req, method, maxOutboundMessageSizeBytes, maxInboundMessageSizeBytes > 0 ? maxInboundMessageSizeBytes : Ints.saturatedCast((long)options.maxResponseLength()), callOptions, CompressorRegistry.getDefaultInstance(), DecompressorRegistry.getDefaultInstance(), this.serializationFormat, this.jsonMarshaller, unsafeWrapResponseBuffers, this.advertisedEncodingsHeader);
    }

    public String authority() {
        return this.params.uri().getAuthority();
    }

    public Scheme scheme() {
        return this.params.scheme();
    }

    public EndpointGroup endpointGroup() {
        return this.params.endpointGroup();
    }

    public String absolutePathRef() {
        return this.params.absolutePathRef();
    }

    public URI uri() {
        return this.params.uri();
    }

    public Class<?> clientType() {
        return this.params.clientType();
    }

    public ClientOptions options() {
        return this.params.options();
    }

    public <T> T as(Class<T> type) {
        Object unwrapped = super.as(type);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)this.httpClient.as(type);
    }

    private DefaultClientRequestContext newContext(HttpMethod method, HttpRequest req) {
        return new DefaultClientRequestContext(this.meterRegistry, this.sessionProtocol, (RequestId)this.options().requestIdGenerator().get(), method, req.path(), null, null, this.options(), req, null, System.nanoTime(), SystemInfo.currentTimeMicros());
    }
}

