/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.DecoratingClientFactory;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.grpc.GrpcClientOptions;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.util.Unwrappable;
import com.linecorp.armeria.internal.client.grpc.ArmeriaChannel;
import com.linecorp.armeria.internal.common.grpc.GrpcJsonUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

final class GrpcClientFactory
extends DecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES = (Set)Arrays.stream(SessionProtocol.values()).flatMap(p -> GrpcSerializationFormats.values().stream().map(f -> Scheme.of((SerializationFormat)f, (SessionProtocol)p))).collect(ImmutableSet.toImmutableSet());
    private static final Consumer<MessageMarshaller.Builder> NO_OP = unused -> {};

    GrpcClientFactory(ClientFactory httpClientFactory) {
        super(httpClientFactory);
    }

    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public Object newClient(ClientBuilderParams params) {
        this.validateParams(params);
        Scheme scheme = params.scheme();
        Class clientType = params.clientType();
        ClientOptions options = params.options();
        SerializationFormat serializationFormat = scheme.serializationFormat();
        Class<?> stubClass = clientType.getEnclosingClass();
        if (stubClass == null) {
            throw GrpcClientFactory.newUnknownClientTypeException(clientType);
        }
        HttpClient httpClient = this.newHttpClient(params);
        Method stubFactoryMethod = GrpcClientFactory.findStubFactoryMethod(clientType, stubClass);
        MessageMarshaller jsonMarshaller = GrpcSerializationFormats.isJson(serializationFormat) ? GrpcJsonUtil.jsonMarshaller(GrpcClientFactory.stubMethods(stubClass), (Consumer)options.get(GrpcClientOptions.JSON_MARSHALLER_CUSTOMIZER)) : null;
        ArmeriaChannel channel = new ArmeriaChannel(params, httpClient, this.meterRegistry(), scheme.sessionProtocol(), serializationFormat, jsonMarshaller);
        try {
            return stubFactoryMethod.invoke(null, new Object[]{channel});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not create a gRPC stub through reflection.", e);
        }
    }

    private static <T> Method findStubFactoryMethod(Class<T> clientType, Class<?> stubClass) {
        Method newStubMethod = null;
        for (Method method : stubClass.getDeclaredMethods()) {
            Class<?>[] methodParameterTypes;
            String methodName;
            int methodModifiers = method.getModifiers();
            if (!Modifier.isPublic(methodModifiers) || !Modifier.isStatic(methodModifiers) || !(methodName = method.getName()).startsWith("new") || !methodName.endsWith("Stub") || (methodParameterTypes = method.getParameterTypes()).length != 1 || methodParameterTypes[0] != Channel.class || !clientType.isAssignableFrom(method.getReturnType())) continue;
            newStubMethod = method;
            break;
        }
        if (newStubMethod == null) {
            throw GrpcClientFactory.newUnknownClientTypeException(clientType);
        }
        return newStubMethod;
    }

    private static IllegalArgumentException newUnknownClientTypeException(Class<?> clientType) {
        return new IllegalArgumentException("Unknown client type: " + clientType.getName() + " (expected: a gRPC client stub class, e.g. MyServiceGrpc.MyServiceStub)");
    }

    public <T> T unwrap(Object client, Class<T> type) {
        Object unwrapped = super.unwrap(client, type);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        if (!(client instanceof AbstractStub)) {
            return null;
        }
        Channel ch = ((AbstractStub)client).getChannel();
        if (!(ch instanceof Unwrappable)) {
            return null;
        }
        return (T)((Unwrappable)ch).as(type);
    }

    private static List<MethodDescriptor<?, ?>> stubMethods(Class<?> stubClass) {
        ServiceDescriptor descriptor;
        Method getServiceDescriptorMethod;
        try {
            getServiceDescriptorMethod = stubClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find getServiceDescriptor on gRPC client stub.");
        }
        try {
            descriptor = (ServiceDescriptor)getServiceDescriptorMethod.invoke(stubClass, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not invoke getServiceDescriptor on a gRPC client stub.");
        }
        return ImmutableList.copyOf((Collection)descriptor.getMethods());
    }
}

