/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

public final class GrpcJsonUtil {
    public static MessageMarshaller jsonMarshaller(List<MethodDescriptor<?, ?>> methods, Consumer<MessageMarshaller.Builder> jsonMarshallerCustomizer) {
        MessageMarshaller.Builder builder = MessageMarshaller.builder().omittingInsignificantWhitespace(true).ignoringUnknownFields(true);
        for (MethodDescriptor<?, ?> method : methods) {
            Message reqPrototype = GrpcJsonUtil.marshallerPrototype(method.getRequestMarshaller());
            Message resPrototype = GrpcJsonUtil.marshallerPrototype(method.getResponseMarshaller());
            if (reqPrototype != null) {
                builder.register(reqPrototype);
            }
            if (resPrototype == null) continue;
            builder.register(resPrototype);
        }
        jsonMarshallerCustomizer.accept(builder);
        return builder.build();
    }

    @Nullable
    private static Message marshallerPrototype(MethodDescriptor.Marshaller<?> marshaller) {
        Object prototype;
        if (marshaller instanceof MethodDescriptor.PrototypeMarshaller && (prototype = ((MethodDescriptor.PrototypeMarshaller)marshaller).getMessagePrototype()) instanceof Message) {
            return (Message)prototype;
        }
        return null;
    }

    private GrpcJsonUtil() {
    }
}

