/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnsafeByteOperations;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.io.ByteStreams;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import javax.annotation.Nullable;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

public final class GrpcMessageMarshaller<I, O> {
    private final ByteBufAllocator alloc;
    private final SerializationFormat serializationFormat;
    private final MethodDescriptor<I, O> method;
    @Nullable
    private final MessageMarshaller jsonMarshaller;
    private final MessageType requestType;
    private final MessageType responseType;
    private final boolean unsafeWrapDeserializedBuffer;

    public GrpcMessageMarshaller(ByteBufAllocator alloc, SerializationFormat serializationFormat, MethodDescriptor<I, O> method, @Nullable MessageMarshaller jsonMarshaller, boolean unsafeWrapDeserializedBuffer) {
        this.alloc = Objects.requireNonNull(alloc, "alloc");
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.method = Objects.requireNonNull(method, "method");
        this.unsafeWrapDeserializedBuffer = unsafeWrapDeserializedBuffer;
        Preconditions.checkArgument((!GrpcSerializationFormats.isJson(serializationFormat) || jsonMarshaller != null ? 1 : 0) != 0, (Object)"jsonMarshaller must be non-null when serializationFormat is JSON.");
        this.jsonMarshaller = jsonMarshaller;
        this.requestType = GrpcMessageMarshaller.marshallerType(method.getRequestMarshaller());
        this.responseType = GrpcMessageMarshaller.marshallerType(method.getResponseMarshaller());
    }

    public ByteBuf serializeRequest(I message) throws IOException {
        switch (this.requestType) {
            case PROTOBUF: {
                return this.serializeProto((Message)message);
            }
        }
        CompositeByteBuf out = this.alloc.compositeBuffer();
        try (ByteBufOutputStream os = new ByteBufOutputStream((ByteBuf)out);){
            ByteStreams.copy((InputStream)this.method.streamRequest(message), (OutputStream)os);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I deserializeRequest(ArmeriaMessageDeframer.DeframedMessage message) throws IOException {
        InputStream messageStream = message.stream();
        if (message.buf() != null) {
            try {
                switch (this.requestType) {
                    case PROTOBUF: {
                        Message msg;
                        MethodDescriptor.PrototypeMarshaller marshaller = (MethodDescriptor.PrototypeMarshaller)this.method.getRequestMarshaller();
                        Message message2 = msg = this.deserializeProto(message.buf(), (Message)marshaller.getMessagePrototype());
                        return (I)message2;
                    }
                }
                messageStream = new ByteBufInputStream(message.buf().retain(), true);
            }
            finally {
                if (!this.unsafeWrapDeserializedBuffer) {
                    message.buf().release();
                }
            }
        }
        try (InputStream msg = messageStream;){
            Object object = this.method.parseRequest(msg);
            return (I)object;
        }
    }

    public ByteBuf serializeResponse(O message) throws IOException {
        switch (this.responseType) {
            case PROTOBUF: {
                return this.serializeProto((Message)message);
            }
        }
        CompositeByteBuf out = this.alloc.compositeBuffer();
        try (ByteBufOutputStream os = new ByteBufOutputStream((ByteBuf)out);){
            ByteStreams.copy((InputStream)this.method.streamResponse(message), (OutputStream)os);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public O deserializeResponse(ArmeriaMessageDeframer.DeframedMessage message) throws IOException {
        InputStream messageStream = message.stream();
        if (message.buf() != null) {
            try {
                switch (this.responseType) {
                    case PROTOBUF: {
                        Message msg;
                        MethodDescriptor.PrototypeMarshaller marshaller = (MethodDescriptor.PrototypeMarshaller)this.method.getResponseMarshaller();
                        Message message2 = msg = this.deserializeProto(message.buf(), (Message)marshaller.getMessagePrototype());
                        return (O)message2;
                    }
                }
                messageStream = new ByteBufInputStream(message.buf().retain(), true);
            }
            finally {
                if (!this.unsafeWrapDeserializedBuffer) {
                    message.buf().release();
                }
            }
        }
        try (InputStream msg = messageStream;){
            Object object = this.method.parseResponse(msg);
            return (O)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf serializeProto(Message message) throws IOException {
        if (GrpcSerializationFormats.isProto(this.serializationFormat)) {
            int serializedSize = message.getSerializedSize();
            if (serializedSize == 0) {
                return Unpooled.EMPTY_BUFFER;
            }
            ByteBuf buf = this.alloc.buffer(serializedSize);
            boolean success = false;
            try {
                message.writeTo(CodedOutputStream.newInstance((ByteBuffer)buf.nioBuffer(0, serializedSize)));
                buf.writerIndex(serializedSize);
                success = true;
            }
            finally {
                if (!success) {
                    buf.release();
                }
            }
            return buf;
        }
        if (GrpcSerializationFormats.isJson(this.serializationFormat)) {
            ByteBuf buf = this.alloc.buffer();
            boolean success = false;
            try (ByteBufOutputStream os = new ByteBufOutputStream(buf);){
                this.jsonMarshaller.writeValue(message, (OutputStream)os);
                success = true;
            }
            finally {
                if (!success) {
                    buf.release();
                }
            }
            return buf;
        }
        throw new IllegalStateException("Unknown serialization format: " + this.serializationFormat);
    }

    private Message deserializeProto(ByteBuf buf, Message prototype) throws IOException {
        if (GrpcSerializationFormats.isProto(this.serializationFormat)) {
            CodedInputStream stream;
            if (!buf.isReadable()) {
                return prototype.getDefaultInstanceForType();
            }
            if (this.unsafeWrapDeserializedBuffer) {
                stream = UnsafeByteOperations.unsafeWrap((ByteBuffer)buf.nioBuffer()).newCodedInput();
                stream.enableAliasing(true);
            } else {
                stream = CodedInputStream.newInstance((ByteBuffer)buf.nioBuffer());
            }
            try {
                Message msg = (Message)prototype.getParserForType().parseFrom(stream);
                try {
                    stream.checkLastTagWas(0);
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage((MessageLite)msg);
                    throw e;
                }
                return msg;
            }
            catch (InvalidProtocolBufferException e) {
                throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
            }
        }
        if (GrpcSerializationFormats.isJson(this.serializationFormat)) {
            Message.Builder builder = prototype.newBuilderForType();
            try (ByteBufInputStream is = new ByteBufInputStream(buf, false);){
                this.jsonMarshaller.mergeValue((InputStream)is, builder);
            }
            return builder.build();
        }
        throw new IllegalStateException("Unknown serialization format: " + this.serializationFormat);
    }

    private static MessageType marshallerType(MethodDescriptor.Marshaller<?> marshaller) {
        return marshaller instanceof MethodDescriptor.PrototypeMarshaller ? MessageType.PROTOBUF : MessageType.UNKNOWN;
    }

    private static enum MessageType {
        UNKNOWN,
        PROTOBUF;

    }
}

