/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.grpc.ForwardingDecompressor;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.common.grpc.TransportStatusListener;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Status;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class HttpStreamReader
implements Subscriber<HttpObject>,
BiFunction<Void, Throwable, Void> {
    private final DecompressorRegistry decompressorRegistry;
    private final TransportStatusListener transportStatusListener;
    @VisibleForTesting
    public final ArmeriaMessageDeframer deframer;
    @Nullable
    private Subscription subscription;
    private int deferredInitialMessageRequest;
    private volatile boolean cancelled;
    private boolean sawLeadingHeaders;

    public HttpStreamReader(DecompressorRegistry decompressorRegistry, ArmeriaMessageDeframer deframer, TransportStatusListener transportStatusListener) {
        this.decompressorRegistry = Objects.requireNonNull(decompressorRegistry, "decompressorRegistry");
        this.deframer = Objects.requireNonNull(deframer, "deframer");
        this.transportStatusListener = Objects.requireNonNull(transportStatusListener, "transportStatusListener");
    }

    public void request(int numMessages) {
        if (this.subscription == null) {
            this.deferredInitialMessageRequest += numMessages;
            return;
        }
        this.deframer.request(numMessages);
        this.requestHttpFrame();
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.cancelled) {
            subscription.cancel();
            return;
        }
        if (this.deferredInitialMessageRequest > 0) {
            this.request(this.deferredInitialMessageRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(HttpObject obj) {
        if (this.cancelled) {
            return;
        }
        if (obj instanceof HttpHeaders) {
            String grpcEncoding;
            String grpcStatus;
            HttpHeaders headers = (HttpHeaders)obj;
            if (!this.sawLeadingHeaders) {
                String statusText = headers.get((CharSequence)HttpHeaderNames.STATUS);
                if (statusText == null) {
                    this.transportStatusListener.transportReportStatus(Status.INTERNAL.withDescription("Missing HTTP status code"));
                    return;
                }
                if (ArmeriaHttpUtil.isInformational((String)statusText)) {
                    return;
                }
                this.sawLeadingHeaders = true;
                HttpStatus status = HttpStatus.valueOf((String)statusText);
                if (!status.equals((Object)HttpStatus.OK)) {
                    this.transportStatusListener.transportReportStatus(GrpcStatus.httpStatusToGrpcStatus(status.code()));
                    return;
                }
            }
            if ((grpcStatus = headers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS)) != null) {
                GrpcStatus.reportStatus(headers, this, this.transportStatusListener);
            }
            if ((grpcEncoding = headers.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING)) != null) {
                Decompressor decompressor = this.decompressorRegistry.lookupDecompressor(grpcEncoding);
                if (decompressor == null) {
                    this.transportStatusListener.transportReportStatus(Status.INTERNAL.withDescription("Can't find decompressor for " + grpcEncoding));
                    return;
                }
                try {
                    this.deframer.decompressor((com.linecorp.armeria.common.grpc.protocol.Decompressor)ForwardingDecompressor.forGrpc(decompressor));
                }
                catch (Throwable t) {
                    this.transportStatusListener.transportReportStatus(GrpcStatus.fromThrowable(t));
                    return;
                }
            }
            this.requestHttpFrame();
            return;
        }
        HttpData data = (HttpData)obj;
        try {
            this.deframer.deframe(data, false);
        }
        catch (Throwable cause) {
            try {
                this.transportStatusListener.transportReportStatus(GrpcStatus.fromThrowable(cause));
                return;
            }
            finally {
                this.deframer.close();
            }
        }
        this.requestHttpFrame();
    }

    public void onError(Throwable cause) {
    }

    public void onComplete() {
    }

    @Override
    public Void apply(@Nullable Void unused, @Nullable Throwable cause) {
        if (this.cancelled) {
            return null;
        }
        if (cause == null) {
            this.closeDeframer();
        } else {
            this.transportStatusListener.transportReportStatus(GrpcStatus.fromThrowable(cause));
        }
        return null;
    }

    public void cancel() {
        this.cancelled = true;
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        if (!this.deframer.isClosed()) {
            this.deframer.close();
        }
    }

    void closeDeframer() {
        if (!this.deframer.isClosed()) {
            this.deframer.deframe(HttpData.empty(), true);
            this.deframer.closeWhenComplete();
        }
    }

    private void requestHttpFrame() {
        assert (this.subscription != null);
        if (this.deframer.isStalled()) {
            this.subscription.request(1L);
        }
    }
}

