/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.grpc.FramedGrpcService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HandlerRegistry;
import com.linecorp.armeria.server.grpc.UnframedGrpcService;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.curioswitch.common.protobuf.json.MessageMarshaller;

public final class GrpcServiceBuilder {
    private static final Set<SerializationFormat> DEFAULT_SUPPORTED_SERIALIZATION_FORMATS = ImmutableSet.of((Object)GrpcSerializationFormats.PROTO, (Object)GrpcSerializationFormats.PROTO_WEB);
    private final HandlerRegistry.Builder registryBuilder = new HandlerRegistry.Builder();
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    private Set<SerializationFormat> supportedSerializationFormats = DEFAULT_SUPPORTED_SERIALIZATION_FORMATS;
    private int maxInboundMessageSizeBytes = -1;
    private int maxOutboundMessageSizeBytes = -1;
    private Consumer<MessageMarshaller.Builder> jsonMarshallerCustomizer = unused -> {};
    private boolean enableUnframedRequests;
    private boolean useBlockingTaskExecutor;
    private boolean unsafeWrapRequestBuffers;
    private boolean useClientTimeoutHeader = true;
    @Nullable
    private ProtoReflectionService protoReflectionService;

    GrpcServiceBuilder() {
    }

    public GrpcServiceBuilder addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(Objects.requireNonNull(service, "service"));
        return this;
    }

    public GrpcServiceBuilder addService(BindableService bindableService) {
        if (bindableService instanceof ProtoReflectionService) {
            Preconditions.checkState((this.protoReflectionService == null ? 1 : 0) != 0, (Object)"Attempting to add a ProtoReflectionService but one is already present. ProtoReflectionService must only be added once.");
            this.protoReflectionService = (ProtoReflectionService)bindableService;
        }
        return this.addService(bindableService.bindService());
    }

    public GrpcServiceBuilder addServices(BindableService ... bindableServices) {
        Objects.requireNonNull(bindableServices, "bindableServices");
        return this.addServices((Iterable<BindableService>)ImmutableList.copyOf((Object[])bindableServices));
    }

    public GrpcServiceBuilder addServices(Iterable<BindableService> bindableServices) {
        Objects.requireNonNull(bindableServices, "bindableServices");
        bindableServices.forEach(this::addService);
        return this;
    }

    public GrpcServiceBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = Objects.requireNonNull(registry, "registry");
        return this;
    }

    public GrpcServiceBuilder compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = Objects.requireNonNull(registry, "registry");
        return this;
    }

    public GrpcServiceBuilder supportedSerializationFormats(SerializationFormat ... formats) {
        return this.supportedSerializationFormats((Iterable<SerializationFormat>)ImmutableSet.copyOf((Object[])Objects.requireNonNull(formats, "formats")));
    }

    public GrpcServiceBuilder supportedSerializationFormats(Iterable<SerializationFormat> formats) {
        Objects.requireNonNull(formats, "formats");
        for (SerializationFormat format : formats) {
            if (GrpcSerializationFormats.isGrpc(format)) continue;
            throw new IllegalArgumentException("Not a gRPC serialization format: " + format);
        }
        this.supportedSerializationFormats = ImmutableSet.copyOf(formats);
        return this;
    }

    public GrpcServiceBuilder setMaxInboundMessageSizeBytes(int maxInboundMessageSizeBytes) {
        Preconditions.checkArgument((maxInboundMessageSizeBytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMessageSizeBytes must be >0");
        this.maxInboundMessageSizeBytes = maxInboundMessageSizeBytes;
        return this;
    }

    public GrpcServiceBuilder setMaxOutboundMessageSizeBytes(int maxOutboundMessageSizeBytes) {
        Preconditions.checkArgument((maxOutboundMessageSizeBytes > 0 ? 1 : 0) != 0, (Object)"maxOutboundMessageSizeBytes must be >0");
        this.maxOutboundMessageSizeBytes = maxOutboundMessageSizeBytes;
        return this;
    }

    public GrpcServiceBuilder enableUnframedRequests(boolean enableUnframedRequests) {
        this.enableUnframedRequests = enableUnframedRequests;
        return this;
    }

    public GrpcServiceBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public GrpcServiceBuilder unsafeWrapRequestBuffers(boolean unsafeWrapRequestBuffers) {
        this.unsafeWrapRequestBuffers = unsafeWrapRequestBuffers;
        return this;
    }

    public GrpcServiceBuilder jsonMarshallerCustomizer(Consumer<MessageMarshaller.Builder> jsonMarshallerCustomizer) {
        this.jsonMarshallerCustomizer = Objects.requireNonNull(jsonMarshallerCustomizer, "jsonMarshallerCustomizer");
        return this;
    }

    public GrpcServiceBuilder useClientTimeoutHeader(boolean useClientTimeoutHeader) {
        this.useClientTimeoutHeader = useClientTimeoutHeader;
        return this;
    }

    public GrpcService build() {
        HandlerRegistry handlerRegistry = this.registryBuilder.build();
        FramedGrpcService grpcService = new FramedGrpcService(handlerRegistry, (Set)handlerRegistry.methods().keySet().stream().map(path -> Route.builder().exact('/' + path).build()).collect(ImmutableSet.toImmutableSet()), (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), this.supportedSerializationFormats, this.jsonMarshallerCustomizer, this.maxOutboundMessageSizeBytes, this.useBlockingTaskExecutor, this.unsafeWrapRequestBuffers, this.useClientTimeoutHeader, this.protoReflectionService, this.maxInboundMessageSizeBytes);
        return this.enableUnframedRequests ? new UnframedGrpcService(grpcService) : grpcService;
    }
}

