/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.grpc.GrpcRequestUtil;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.unsafe.ByteBufHttpData;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;

final class UnframedGrpcService
extends SimpleDecoratingHttpService
implements GrpcService {
    private static final char LINE_SEPARATOR = '\n';
    private final Map<String, MethodDescriptor<?, ?>> methodsByName;
    private final GrpcService delegateGrpcService;

    UnframedGrpcService(GrpcService delegate) {
        super((HttpService)delegate);
        Preconditions.checkArgument((boolean)delegate.isFramed(), (Object)"Decorated service must be a framed GrpcService.");
        this.delegateGrpcService = delegate;
        this.methodsByName = (Map)delegate.services().stream().flatMap(service -> service.getMethods().stream()).map(ServerMethodDefinition::getMethodDescriptor).collect(ImmutableMap.toImmutableMap(MethodDescriptor::getFullMethodName, Function.identity()));
    }

    @Override
    public boolean isFramed() {
        return false;
    }

    @Override
    public List<ServerServiceDefinition> services() {
        return this.delegateGrpcService.services();
    }

    @Override
    public Set<SerializationFormat> supportedSerializationFormats() {
        return this.delegateGrpcService.supportedSerializationFormats();
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        MediaType framedContentType;
        MethodDescriptor<?, ?> method;
        RequestHeaders clientHeaders = req.headers();
        MediaType contentType = clientHeaders.contentType();
        if (contentType == null) {
            return (HttpResponse)((Service)this.delegate()).serve(ctx, (Request)req);
        }
        for (SerializationFormat format : GrpcSerializationFormats.values()) {
            if (!format.isAccepted(contentType)) continue;
            return (HttpResponse)((Service)this.delegate()).serve(ctx, (Request)req);
        }
        String methodName = GrpcRequestUtil.determineMethod(ctx);
        MethodDescriptor<?, ?> methodDescriptor = method = methodName != null ? this.methodsByName.get(methodName) : null;
        if (method == null) {
            return (HttpResponse)((Service)this.delegate()).serve(ctx, (Request)req);
        }
        if (method.getType() != MethodDescriptor.MethodType.UNARY) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Only unary methods can be used with non-framed requests.");
        }
        RequestHeadersBuilder grpcHeaders = clientHeaders.toBuilder();
        if (contentType.is(MediaType.PROTOBUF)) {
            framedContentType = GrpcSerializationFormats.PROTO.mediaType();
        } else if (contentType.is(MediaType.JSON_UTF_8)) {
            framedContentType = GrpcSerializationFormats.JSON.mediaType();
        } else {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Unsupported media type. Only application/protobuf is supported.");
        }
        grpcHeaders.contentType(framedContentType);
        if (grpcHeaders.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING) != null) {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"gRPC encoding is not supported for non-framed requests.");
        }
        grpcHeaders.remove((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING);
        ctx.logBuilder().deferRequestContent();
        ctx.logBuilder().deferResponseContent();
        CompletableFuture responseFuture = new CompletableFuture();
        req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).handle((clientRequest, t) -> {
            if (t != null) {
                responseFuture.completeExceptionally((Throwable)t);
            } else {
                this.frameAndServe(ctx, grpcHeaders.build(), (AggregatedHttpRequest)clientRequest, responseFuture);
            }
            return null;
        });
        return HttpResponse.from(responseFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frameAndServe(ServiceRequestContext ctx, RequestHeaders grpcHeaders, AggregatedHttpRequest clientRequest, CompletableFuture<HttpResponse> res) {
        HttpResponse grpcResponse;
        HttpRequest grpcRequest;
        try (ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), -1);){
            ByteBufHttpData frame;
            ByteBuf message;
            HttpData content = clientRequest.content();
            if (content instanceof ByteBufHolder) {
                message = ((ByteBufHolder)content).content();
            } else {
                message = ctx.alloc().buffer(content.length());
                message.writeBytes(content.array());
            }
            boolean success = false;
            try {
                frame = framer.writePayload(message);
                success = true;
            }
            finally {
                if (!success) {
                    message.release();
                }
            }
            grpcRequest = HttpRequest.of((RequestHeaders)grpcHeaders, (HttpData)frame);
        }
        try {
            grpcResponse = (HttpResponse)((Service)this.delegate()).serve(ctx, (Request)grpcRequest);
        }
        catch (Exception e) {
            res.completeExceptionally(e);
            return;
        }
        grpcResponse.aggregate().handleAsync((framedResponse, t) -> {
            if (t != null) {
                res.completeExceptionally((Throwable)t);
            } else {
                UnframedGrpcService.deframeAndRespond(ctx, framedResponse, res);
            }
            return null;
        }, (Executor)ctx.eventLoop());
    }

    private static void deframeAndRespond(ServiceRequestContext ctx, AggregatedHttpResponse grpcResponse, final CompletableFuture<HttpResponse> res) {
        Object trailers = !grpcResponse.trailers().isEmpty() ? grpcResponse.trailers() : grpcResponse.headers();
        String grpcStatusCode = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        Status grpcStatus = Status.fromCodeValue((int)Integer.parseInt(grpcStatusCode));
        if (grpcStatus.getCode() != Status.OK.getCode()) {
            HttpStatus httpStatus = GrpcStatus.grpcCodeToHttpStatus(grpcStatus.getCode());
            StringBuilder message = new StringBuilder("http-status: " + httpStatus.code());
            message.append(", ").append(httpStatus.reasonPhrase()).append('\n');
            message.append("Caused by: ").append('\n');
            message.append("grpc-status: ").append(grpcStatusCode).append(", ").append(grpcStatus.getCode().name());
            String grpcMessage = trailers.get((CharSequence)GrpcHeaderNames.GRPC_MESSAGE);
            if (grpcMessage != null) {
                message.append(", ").append(grpcMessage);
            }
            res.complete(HttpResponse.of((HttpStatus)httpStatus, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)message.toString()));
            return;
        }
        MediaType grpcMediaType = grpcResponse.contentType();
        final ResponseHeadersBuilder unframedHeaders = grpcResponse.headers().toBuilder();
        if (grpcMediaType != null) {
            if (grpcMediaType.is(GrpcSerializationFormats.PROTO.mediaType())) {
                unframedHeaders.contentType(MediaType.PROTOBUF);
            } else if (grpcMediaType.is(GrpcSerializationFormats.JSON.mediaType())) {
                unframedHeaders.contentType(MediaType.JSON_UTF_8);
            }
        }
        try (ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(new ArmeriaMessageDeframer.Listener(){

            public void messageRead(ArmeriaMessageDeframer.DeframedMessage message) {
                ByteBufHttpData unframedContent = new ByteBufHttpData(message.buf(), true);
                unframedHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, unframedContent.length());
                res.complete(HttpResponse.of((ResponseHeaders)unframedHeaders.build(), (HttpData)unframedContent));
            }

            public void endOfStream() {
                if (!res.isDone()) {
                    res.complete(HttpResponse.of((ResponseHeaders)unframedHeaders.build()));
                }
            }
        }, Integer.MAX_VALUE, ctx.alloc());){
            deframer.request(1);
            deframer.deframe(grpcResponse.content(), true);
        }
    }

    public Set<Route> routes() {
        return this.delegateGrpcService.routes();
    }
}

