/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.grpc.GrpcWebTrailers;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.common.metric.DefaultMeterIdPrefixFunction;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Objects;

public final class GrpcMeterIdPrefixFunction
implements MeterIdPrefixFunction {
    private final String name;

    public static GrpcMeterIdPrefixFunction of(String name) {
        return new GrpcMeterIdPrefixFunction(name);
    }

    private GrpcMeterIdPrefixFunction(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestOnlyLog log) {
        ImmutableList.Builder tagListBuilder = ImmutableList.builderWithExpectedSize((int)3);
        DefaultMeterIdPrefixFunction.addActiveRequestPrefixTags((ImmutableList.Builder)tagListBuilder, (RequestOnlyLog)log);
        return new MeterIdPrefix(this.name, (Iterable)tagListBuilder.build());
    }

    public MeterIdPrefix completeRequestPrefix(MeterRegistry registry, RequestLog log) {
        ImmutableList.Builder tagListBuilder = ImmutableList.builderWithExpectedSize((int)4);
        GrpcMeterIdPrefixFunction.addGrpcStatus((ImmutableList.Builder<Tag>)tagListBuilder, log);
        DefaultMeterIdPrefixFunction.addCompleteRequestPrefixTags((ImmutableList.Builder)tagListBuilder, (RequestLog)log);
        return new MeterIdPrefix(this.name, (Iterable)tagListBuilder.build());
    }

    private static void addGrpcStatus(ImmutableList.Builder<Tag> tagListBuilder, RequestLog log) {
        String status = log.responseHeaders().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        if (status != null) {
            tagListBuilder.add((Object)Tag.of((String)"grpc.status", (String)status));
            return;
        }
        status = log.responseTrailers().get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        if (status != null) {
            tagListBuilder.add((Object)Tag.of((String)"grpc.status", (String)status));
            return;
        }
        HttpHeaders trailers = GrpcWebTrailers.get(log.context());
        if (trailers != null && (status = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS)) != null) {
            tagListBuilder.add((Object)Tag.of((String)"grpc.status", (String)status));
            return;
        }
        tagListBuilder.add((Object)Tag.of((String)"grpc.status", (String)String.valueOf(2)));
    }
}

