/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.DecoratingClientFactory;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.grpc.GrpcClientOptions;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.util.Unwrappable;
import com.linecorp.armeria.internal.client.grpc.ArmeriaChannel;
import com.linecorp.armeria.internal.client.grpc.GrpcClientUtil;
import com.linecorp.armeria.internal.client.grpc.GrpcWebTrailersExtractor;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.AbstractStub;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

final class GrpcClientFactory
extends DecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES = (Set)Arrays.stream(SessionProtocol.values()).flatMap(p -> GrpcSerializationFormats.values().stream().map(f -> Scheme.of((SerializationFormat)f, (SessionProtocol)p))).collect(ImmutableSet.toImmutableSet());

    GrpcClientFactory(ClientFactory httpClientFactory) {
        super(httpClientFactory);
    }

    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public Object newClient(ClientBuilderParams params) {
        this.validateParams(params);
        Scheme scheme = params.scheme();
        Class clientType = params.clientType();
        ClientOptions options = params.options();
        SerializationFormat serializationFormat = scheme.serializationFormat();
        Class<?> enclosingClass = clientType.getEnclosingClass();
        if (enclosingClass == null) {
            throw GrpcClientFactory.newUnknownClientTypeException(clientType);
        }
        ClientBuilderParams newParams = GrpcClientFactory.addTrailersExtractor(params, options, serializationFormat);
        HttpClient httpClient = this.newHttpClient(newParams);
        GrpcJsonMarshaller jsonMarshaller = GrpcSerializationFormats.isJson(serializationFormat) ? (GrpcJsonMarshaller)((Function)options.get(GrpcClientOptions.GRPC_JSON_MARSHALLER_FACTORY)).apply(GrpcClientFactory.getServiceDescriptor(clientType)) : null;
        ArmeriaChannel channel = new ArmeriaChannel(newParams, httpClient, this.meterRegistry(), scheme.sessionProtocol(), serializationFormat, jsonMarshaller);
        Method stubFactoryMethod = GrpcClientFactory.findStubFactoryMethod(clientType, enclosingClass);
        try {
            if (stubFactoryMethod != null) {
                return stubFactoryMethod.invoke(null, new Object[]{channel});
            }
            Constructor<?> stubConstructor = GrpcClientFactory.findStubConstructor(clientType);
            if (stubConstructor == null) {
                throw GrpcClientFactory.newUnknownClientTypeException(clientType);
            }
            return stubConstructor.newInstance(new Object[]{channel});
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException("Could not create a gRPC stub through reflection.", e);
        }
    }

    private static ClientBuilderParams addTrailersExtractor(ClientBuilderParams params, ClientOptions options, SerializationFormat serializationFormat) {
        if (!GrpcSerializationFormats.isGrpcWeb(serializationFormat)) {
            return params;
        }
        ClientDecoration originalDecoration = options.decoration();
        List decorators = originalDecoration.decorators();
        boolean foundRetryingClient = false;
        HttpClient noopClient = (ctx, req) -> null;
        for (Function decorator : decorators) {
            HttpClient decorated = (HttpClient)decorator.apply(noopClient);
            if (!(decorated instanceof RetryingClient)) continue;
            foundRetryingClient = true;
            break;
        }
        if (!foundRetryingClient) {
            return params;
        }
        GrpcWebTrailersExtractor webTrailersExtractor = new GrpcWebTrailersExtractor(GrpcClientUtil.maxInboundMessageSizeBytes(options), GrpcSerializationFormats.isGrpcWebText(serializationFormat));
        ClientOptionsBuilder optionsBuilder = options.toBuilder();
        optionsBuilder.clearDecorators();
        optionsBuilder.decorator((DecoratingHttpClientFunction)webTrailersExtractor);
        decorators.forEach(arg_0 -> ((ClientOptionsBuilder)optionsBuilder).decorator(arg_0));
        return ClientBuilderParams.of((Scheme)params.scheme(), (EndpointGroup)params.endpointGroup(), (String)params.absolutePathRef(), (Class)params.clientType(), (ClientOptions)optionsBuilder.build());
    }

    @Nullable
    private static <T> Method findStubFactoryMethod(Class<T> clientType, Class<?> enclosingClass) {
        Method newStubMethod = null;
        for (Method method : enclosingClass.getDeclaredMethods()) {
            Class<?>[] methodParameterTypes;
            String methodName;
            int methodModifiers = method.getModifiers();
            if (!Modifier.isPublic(methodModifiers) || !Modifier.isStatic(methodModifiers) || !(methodName = method.getName()).toLowerCase().endsWith("stub") || (methodParameterTypes = method.getParameterTypes()).length != 1 || methodParameterTypes[0] != Channel.class || !clientType.isAssignableFrom(method.getReturnType())) continue;
            newStubMethod = method;
            break;
        }
        return newStubMethod;
    }

    @Nullable
    private static <T> Constructor<?> findStubConstructor(Class<T> clientType) {
        if (!clientType.getName().endsWith("CoroutineStub")) {
            return null;
        }
        for (Constructor<?> constructor : clientType.getConstructors()) {
            Class<?>[] methodParameterTypes = constructor.getParameterTypes();
            if (methodParameterTypes.length != 1 || methodParameterTypes[0] != Channel.class) continue;
            return constructor;
        }
        return null;
    }

    private static IllegalArgumentException newUnknownClientTypeException(Class<?> clientType) {
        return new IllegalArgumentException("Unknown client type: " + clientType.getName() + " (expected: a gRPC client stub class, e.g. MyServiceGrpc.MyServiceStub)");
    }

    public <T> T unwrap(Object client, Class<T> type) {
        Object unwrapped = super.unwrap(client, type);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        if (!(client instanceof AbstractStub)) {
            return null;
        }
        Channel ch = ((AbstractStub)client).getChannel();
        if (!(ch instanceof Unwrappable)) {
            return null;
        }
        return (T)((Unwrappable)ch).as(type);
    }

    private static ServiceDescriptor getServiceDescriptor(Class<?> clientType) {
        Method getServiceDescriptorMethod;
        if (clientType.getName().endsWith("CoroutineStub")) {
            Annotation annotation = GrpcClientFactory.stubForAnnotation(clientType);
            try {
                Method valueMethod = annotation.annotationType().getDeclaredMethod("value", null);
                Class<?> generatedStub = GrpcClientFactory.generatedStub(annotation, valueMethod);
                Method getServiceDescriptor = generatedStub.getDeclaredMethod("getServiceDescriptor", null);
                try {
                    return (ServiceDescriptor)getServiceDescriptor.invoke(generatedStub, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("Could not invoke getServiceDescriptor on a gRPC Kotlin client stub.");
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not find value getter on StubFor annotation.");
            }
        }
        Class<?> stubClass = clientType.getEnclosingClass();
        try {
            getServiceDescriptorMethod = stubClass.getDeclaredMethod("getServiceDescriptor", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                getServiceDescriptorMethod = stubClass.getDeclaredMethod("SERVICE", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException("Could not find a io.grpc.ServiceDescriptor on a gRPC client stub.");
            }
        }
        try {
            return (ServiceDescriptor)getServiceDescriptorMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not invoke getServiceDescriptor on a gRPC client stub.");
        }
    }

    private static Class<?> generatedStub(Annotation annotation, Method valueMethod) {
        try {
            return (Class)valueMethod.invoke((Object)annotation, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not find a gRPC Kotlin generated client stub.");
        }
    }

    private static Annotation stubForAnnotation(Class<?> clientType) {
        try {
            Class<?> annotationClass = Class.forName("io.grpc.kotlin.StubFor");
            Object annotation = clientType.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new IllegalStateException("Could not find StubFor annotation on a gRPC Kotlin client stub.");
            }
            return annotation;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find StubFor annotation on a gRPC Kotlin client stub.");
        }
    }
}

