/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.grpc.GrpcWebTrailers;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.internal.client.grpc.InternalGrpcWebUtil;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.grpc.ForwardingDecompressor;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import org.reactivestreams.Subscriber;

public final class GrpcWebTrailersExtractor
implements DecoratingHttpClientFunction {
    private final int maxMessageSizeBytes;
    private final boolean grpcWebText;

    GrpcWebTrailersExtractor(int maxMessageSizeBytes, boolean grpcWebText) {
        this.maxMessageSizeBytes = maxMessageSizeBytes;
        this.grpcWebText = grpcWebText;
    }

    public HttpResponse execute(HttpClient delegate, final ClientRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponse response = delegate.execute(ctx, req);
        final ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(new ArmeriaMessageDeframer.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageRead(ArmeriaMessageDeframer.DeframedMessage message) {
                if (message.type() >> 7 == 1) {
                    ByteBuf buf;
                    try {
                        buf = InternalGrpcWebUtil.messageBuf(message, ctx.alloc());
                    }
                    catch (IOException e) {
                        return;
                    }
                    try {
                        HttpHeaders trailers = InternalGrpcWebUtil.parseGrpcWebTrailers(buf);
                        if (trailers == null) {
                            return;
                        }
                        GrpcWebTrailers.set((RequestContext)ctx, trailers);
                    }
                    finally {
                        buf.release();
                    }
                }
                ByteBuf buf = message.buf();
                if (buf != null) {
                    buf.release();
                } else {
                    try {
                        InputStream stream = message.stream();
                        assert (stream != null);
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }

            public void endOfStream() {
            }
        }, this.maxMessageSizeBytes, ctx.alloc(), this.grpcWebText);
        FilteredHttpResponse filteredHttpResponse = new FilteredHttpResponse(response, true){

            protected HttpObject filter(HttpObject obj) {
                if (obj instanceof ResponseHeaders) {
                    ResponseHeaders headers = (ResponseHeaders)obj;
                    String statusText = headers.get((CharSequence)HttpHeaderNames.STATUS);
                    if (statusText == null) {
                        deframer.close();
                        return obj;
                    }
                    if (ArmeriaHttpUtil.isInformational((String)statusText)) {
                        return obj;
                    }
                    HttpStatus status = HttpStatus.valueOf((String)statusText);
                    if (!status.equals((Object)HttpStatus.OK)) {
                        deframer.close();
                        return obj;
                    }
                    String grpcEncoding = headers.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING);
                    if (grpcEncoding != null) {
                        Decompressor decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(grpcEncoding);
                        if (decompressor == null) {
                            deframer.close();
                            return obj;
                        }
                        deframer.decompressor((com.linecorp.armeria.common.grpc.protocol.Decompressor)ForwardingDecompressor.forGrpc(decompressor));
                    }
                    deframer.request(Integer.MAX_VALUE);
                    return obj;
                }
                if (obj instanceof HttpData && !deframer.isClosed()) {
                    HttpData httpData = (HttpData)obj;
                    HttpData wrapped = HttpData.wrap((ByteBuf)httpData.byteBuf(ByteBufAccessMode.RETAINED_DUPLICATE));
                    deframer.deframe(wrapped, wrapped.isEndOfStream());
                }
                return obj;
            }

            protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
                deframer.close();
            }

            protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
                deframer.close();
                return cause;
            }
        };
        filteredHttpResponse.whenComplete().handle((unused, unused2) -> {
            deframer.close();
            return null;
        });
        return filteredHttpResponse;
    }
}

