/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.internal.shaded.guava.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.ByteProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public final class InternalGrpcWebUtil {
    private static final ByteProcessor FIND_COLON = new ByteProcessor.IndexOfProcessor(58);

    public static ByteBuf messageBuf(ArmeriaMessageDeframer.DeframedMessage message, ByteBufAllocator alloc) throws IOException {
        ByteBuf buf;
        ByteBuf messageBuf = message.buf();
        if (messageBuf != null) {
            buf = messageBuf;
        } else {
            buf = alloc.compositeBuffer();
            boolean success = false;
            try (ByteBufOutputStream os = new ByteBufOutputStream(buf);
                 InputStream stream = message.stream();){
                assert (stream != null);
                ByteStreams.copy((InputStream)stream, (OutputStream)os);
                success = true;
            }
            catch (Throwable t) {
                if (!success) {
                    buf.release();
                }
                throw t;
            }
        }
        return buf;
    }

    @Nullable
    public static HttpHeaders parseGrpcWebTrailers(ByteBuf buf) {
        HttpHeadersBuilder trailers = HttpHeaders.builder();
        while (buf.readableBytes() > 0) {
            int endExclusive;
            int start = buf.forEachByte(ByteProcessor.FIND_NON_LINEAR_WHITESPACE);
            if (start == -1) {
                return null;
            }
            if (buf.getByte(start) == 58) {
                buf.skipBytes(1);
                endExclusive = buf.forEachByte(FIND_COLON);
                buf.readerIndex(start);
            } else {
                endExclusive = buf.forEachByte(FIND_COLON);
            }
            if (endExclusive == -1) {
                return null;
            }
            CharSequence name = buf.readCharSequence(endExclusive - start, StandardCharsets.UTF_8);
            buf.readerIndex(endExclusive + 1);
            start = buf.forEachByte(ByteProcessor.FIND_NON_LINEAR_WHITESPACE);
            buf.readerIndex(start);
            endExclusive = buf.forEachByte(ByteProcessor.FIND_CRLF);
            CharSequence value = buf.readCharSequence(endExclusive - start, StandardCharsets.UTF_8);
            trailers.add(name, value.toString());
            start = buf.forEachByte(ByteProcessor.FIND_NON_CRLF);
            if (start != -1) {
                buf.readerIndex(start);
                continue;
            }
            buf.skipBytes(buf.readableBytes());
        }
        return trailers.build();
    }

    private InternalGrpcWebUtil() {
    }
}

