/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.GrpcWebTrailers;
import com.linecorp.armeria.common.grpc.ThrowableProto;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.grpc.ForwardingCompressor;
import com.linecorp.armeria.internal.common.grpc.ForwardingDecompressor;
import com.linecorp.armeria.internal.common.grpc.GrpcLogUtil;
import com.linecorp.armeria.internal.common.grpc.GrpcMessageMarshaller;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.common.grpc.HttpStreamReader;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import com.linecorp.armeria.internal.common.grpc.TransportStatusListener;
import com.linecorp.armeria.internal.common.grpc.protocol.GrpcTrailersUtil;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.util.concurrent.MoreExecutors;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.unsafe.grpc.GrpcUnsafeBufferUtil;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.StatusException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArmeriaServerCall<I, O>
extends ServerCall<I, O>
implements ArmeriaMessageDeframer.Listener,
TransportStatusListener {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaServerCall.class);
    private static final AtomicIntegerFieldUpdater<ArmeriaServerCall> pendingMessagesUpdater = AtomicIntegerFieldUpdater.newUpdater(ArmeriaServerCall.class, "pendingMessages");
    private static final Splitter ACCEPT_ENCODING_SPLITTER = Splitter.on((char)',').trimResults();
    private final MethodDescriptor<I, O> method;
    private final HttpStreamReader messageReader;
    private final ArmeriaMessageFramer messageFramer;
    private final HttpResponseWriter res;
    private final CompressorRegistry compressorRegistry;
    private final ServiceRequestContext ctx;
    private final SerializationFormat serializationFormat;
    private final GrpcMessageMarshaller<I, O> marshaller;
    private final boolean unsafeWrapRequestBuffers;
    @Nullable
    private final Executor blockingExecutor;
    private final ResponseHeaders defaultHeaders;
    @Nullable
    private ServerCall.Listener<I> listener;
    @Nullable
    private O firstResponse;
    @Nullable
    private final String clientAcceptEncoding;
    @Nullable
    private Compressor compressor;
    private boolean messageCompression = true;
    private boolean messageReceived;
    private volatile boolean cancelled;
    private volatile boolean clientStreamClosed;
    private volatile boolean listenerClosed;
    private boolean sendHeadersCalled;
    private boolean closeCalled;
    private volatile int pendingMessages;

    ArmeriaServerCall(HttpHeaders clientHeaders, MethodDescriptor<I, O> method, CompressorRegistry compressorRegistry, DecompressorRegistry decompressorRegistry, HttpResponseWriter res, int maxInboundMessageSizeBytes, int maxOutboundMessageSizeBytes, ServiceRequestContext ctx, SerializationFormat serializationFormat, @Nullable GrpcJsonMarshaller jsonMarshaller, boolean unsafeWrapRequestBuffers, boolean useBlockingTaskExecutor, ResponseHeaders defaultHeaders) {
        Objects.requireNonNull(clientHeaders, "clientHeaders");
        this.method = Objects.requireNonNull(method, "method");
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.defaultHeaders = Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(serializationFormat);
        this.messageReader = new HttpStreamReader(Objects.requireNonNull(decompressorRegistry, "decompressorRegistry"), new ArmeriaMessageDeframer((ArmeriaMessageDeframer.Listener)this, maxInboundMessageSizeBytes, ctx.alloc(), grpcWebText).decompressor(ArmeriaServerCall.clientDecompressor(clientHeaders, decompressorRegistry)), this);
        this.messageFramer = new ArmeriaMessageFramer(ctx.alloc(), maxOutboundMessageSizeBytes, grpcWebText);
        this.res = Objects.requireNonNull(res, "res");
        this.compressorRegistry = Objects.requireNonNull(compressorRegistry, "compressorRegistry");
        this.clientAcceptEncoding = Strings.emptyToNull((String)clientHeaders.get((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING));
        this.marshaller = new GrpcMessageMarshaller<I, O>(ctx.alloc(), serializationFormat, method, jsonMarshaller, unsafeWrapRequestBuffers);
        this.unsafeWrapRequestBuffers = unsafeWrapRequestBuffers;
        this.blockingExecutor = useBlockingTaskExecutor ? MoreExecutors.newSequentialExecutor((Executor)ctx.blockingTaskExecutor()) : null;
        res.whenComplete().handleAsync((unused, t) -> {
            if (!this.closeCalled) {
                this.cancelled = true;
                try (SafeCloseable ignore = ctx.push();){
                    this.close(Status.CANCELLED, new Metadata());
                }
            }
            return null;
        }, (Executor)ctx.eventLoop());
    }

    public void request(int numMessages) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.messageReader.request(numMessages);
        } else {
            this.ctx.eventLoop().execute(() -> this.messageReader.request(numMessages));
        }
    }

    public void sendHeaders(Metadata metadata) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doSendHeaders(metadata);
        } else {
            this.ctx.eventLoop().execute(() -> this.doSendHeaders(metadata));
        }
    }

    private void doSendHeaders(Metadata metadata) {
        Preconditions.checkState((!this.sendHeadersCalled ? 1 : 0) != 0, (Object)"sendHeaders already called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        if (this.compressor == null || !this.messageCompression || this.clientAcceptEncoding == null) {
            this.compressor = Codec.Identity.NONE;
        } else {
            List acceptedEncodingsList = ACCEPT_ENCODING_SPLITTER.splitToList((CharSequence)this.clientAcceptEncoding);
            if (!acceptedEncodingsList.contains(this.compressor.getMessageEncoding())) {
                this.compressor = Codec.Identity.NONE;
            }
        }
        this.messageFramer.setCompressor(ForwardingCompressor.forGrpc(this.compressor));
        ResponseHeaders headers = this.defaultHeaders;
        if (this.compressor != Codec.Identity.NONE || InternalMetadata.headerCount((Metadata)metadata) > 0) {
            headers = headers.withMutations(builder -> {
                if (this.compressor != Codec.Identity.NONE) {
                    builder.set((CharSequence)GrpcHeaderNames.GRPC_ENCODING, this.compressor.getMessageEncoding());
                }
                MetadataUtil.fillHeaders(metadata, builder);
            });
        }
        this.sendHeadersCalled = true;
        this.res.write((Object)headers);
    }

    public void sendMessage(O message) {
        pendingMessagesUpdater.incrementAndGet(this);
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doSendMessage(message);
        } else {
            this.ctx.eventLoop().execute(() -> this.doSendMessage(message));
        }
    }

    private void doSendMessage(O message) {
        Preconditions.checkState((boolean)this.sendHeadersCalled, (Object)"sendHeaders has not been called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        if (this.firstResponse == null) {
            this.firstResponse = message;
        }
        try {
            this.res.write((Object)this.messageFramer.writePayload(this.marshaller.serializeResponse(message)));
            this.res.whenConsumed().thenRun(() -> {
                if (pendingMessagesUpdater.decrementAndGet(this) == 0) {
                    if (this.blockingExecutor != null) {
                        this.blockingExecutor.execute(this::invokeOnReady);
                    } else {
                        this.invokeOnReady();
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.close(GrpcStatus.fromThrowable(e), new Metadata());
            throw e;
        }
        catch (Throwable t) {
            this.close(GrpcStatus.fromThrowable(t), new Metadata());
            throw new RuntimeException(t);
        }
    }

    private void invokeOnReady() {
        try {
            this.listener.onReady();
        }
        catch (Throwable t) {
            this.close(GrpcStatus.fromThrowable(t), new Metadata());
        }
    }

    public boolean isReady() {
        return !this.closeCalled && this.pendingMessages == 0;
    }

    public void close(Status status, Metadata metadata) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doClose(status, metadata);
        } else {
            this.ctx.eventLoop().execute(() -> this.doClose(status, metadata));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(Status status, Metadata metadata) {
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call already closed");
        this.closeCalled = true;
        if (this.cancelled) {
            this.closeListener(status);
            return;
        }
        HttpHeaders trailers = ArmeriaServerCall.statusToTrailers(this.ctx, (HttpHeadersBuilder)(this.sendHeadersCalled ? HttpHeaders.builder() : this.defaultHeaders.toBuilder()), status, metadata);
        try {
            if (this.sendHeadersCalled && GrpcSerializationFormats.isGrpcWeb(this.serializationFormat)) {
                GrpcWebTrailers.set((RequestContext)this.ctx, trailers);
                ByteBuf serialized = GrpcTrailersUtil.serializeTrailersAsMessage((ByteBufAllocator)this.ctx.alloc(), (HttpHeaders)trailers);
                if (this.res.tryWrite((Object)this.messageFramer.writePayload(serialized, true))) {
                    this.res.close();
                }
            } else if (this.res.tryWrite((Object)trailers)) {
                this.res.close();
            }
        }
        finally {
            this.closeListener(status);
        }
    }

    @VisibleForTesting
    boolean isCloseCalled() {
        return this.closeCalled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void setMessageCompression(boolean messageCompression) {
        this.messageFramer.setMessageCompression(messageCompression);
        this.messageCompression = messageCompression;
    }

    public synchronized void setCompression(String compressorName) {
        Preconditions.checkState((!this.sendHeadersCalled ? 1 : 0) != 0, (Object)"sendHeaders has been called");
        this.compressor = this.compressorRegistry.lookupCompressor(compressorName);
        Preconditions.checkArgument((this.compressor != null ? 1 : 0) != 0, (String)"Unable to find compressor by name %s", (Object)compressorName);
        this.messageFramer.setCompressor(ForwardingCompressor.forGrpc(this.compressor));
    }

    public MethodDescriptor<I, O> getMethodDescriptor() {
        return this.method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageRead(ArmeriaMessageDeframer.DeframedMessage message) {
        I request;
        ByteBuf buf = message.buf();
        boolean success = false;
        try {
            if (this.messageReceived && this.method.getType() == MethodDescriptor.MethodType.UNARY) {
                this.closeListener(Status.INTERNAL.withDescription("More than one request messages for unary call or server streaming call"));
                return;
            }
            this.messageReceived = true;
            if (this.isCancelled()) {
                return;
            }
            success = true;
        }
        finally {
            if (buf != null && !success) {
                buf.release();
            }
        }
        boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(this.serializationFormat);
        try {
            request = this.marshaller.deserializeRequest(message, grpcWebText);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!this.ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
            this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method, request), null);
        }
        if (this.unsafeWrapRequestBuffers && buf != null && !grpcWebText) {
            GrpcUnsafeBufferUtil.storeBuffer(buf, request, (RequestContext)this.ctx);
        }
        if (this.blockingExecutor != null) {
            this.blockingExecutor.execute(() -> this.invokeOnMessage(request));
        } else {
            this.invokeOnMessage(request);
        }
    }

    private void invokeOnMessage(I request) {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.onMessage(request);
        }
        catch (Throwable t) {
            this.close(GrpcStatus.fromThrowable(t), new Metadata());
        }
    }

    public void endOfStream() {
        this.setClientStreamClosed();
        if (!this.closeCalled) {
            if (!this.ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
                this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method), null);
            }
            if (this.blockingExecutor != null) {
                this.blockingExecutor.execute(this::invokeHalfClose);
            } else {
                this.invokeHalfClose();
            }
        }
    }

    private void invokeHalfClose() {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.onHalfClose();
        }
        catch (Throwable t) {
            this.close(GrpcStatus.fromThrowable(t), new Metadata());
        }
    }

    @Override
    public void transportReportStatus(Status status, Metadata unused) {
        if (this.closeCalled) {
            return;
        }
        this.closeListener(status);
    }

    private void closeListener(Status newStatus) {
        if (!this.listenerClosed) {
            this.listenerClosed = true;
            this.setClientStreamClosed();
            this.messageFramer.close();
            this.ctx.logBuilder().responseContent((Object)GrpcLogUtil.rpcResponse(newStatus, this.firstResponse), null);
            if (newStatus.isOk()) {
                if (this.blockingExecutor != null) {
                    this.blockingExecutor.execute(this::invokeOnComplete);
                } else {
                    this.invokeOnComplete();
                }
            } else {
                this.cancelled = true;
                if (this.blockingExecutor != null) {
                    this.blockingExecutor.execute(this::invokeOnCancel);
                } else {
                    this.invokeOnCancel();
                }
                if (!this.closeCalled) {
                    StatusException statusException = newStatus.asException();
                    Throwable cause = statusException.getCause();
                    if (cause != null) {
                        this.res.close(cause);
                    } else {
                        this.res.abort();
                    }
                }
            }
        }
    }

    private void invokeOnComplete() {
        try (SafeCloseable ignored = this.ctx.push();){
            this.listener.onComplete();
        }
        catch (Throwable t) {
            logger.warn("Error in gRPC onComplete handler.", t);
        }
    }

    private void invokeOnCancel() {
        block8: {
            try (SafeCloseable ignored = this.ctx.push();){
                this.listener.onCancel();
            }
            catch (Throwable t) {
                if (this.closeCalled) break block8;
                this.close(GrpcStatus.fromThrowable(t), new Metadata());
            }
        }
    }

    private void setClientStreamClosed() {
        if (!this.clientStreamClosed) {
            this.messageReader().cancel();
            this.clientStreamClosed = true;
        }
    }

    static HttpHeaders statusToTrailers(ServiceRequestContext ctx, HttpHeadersBuilder trailersBuilder, Status status, Metadata metadata) {
        GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailersBuilder, (int)status.getCode().value(), (String)status.getDescription());
        MetadataUtil.fillHeaders(metadata, trailersBuilder);
        if (ctx.config().verboseResponses() && status.getCause() != null) {
            ThrowableProto proto = GrpcStatus.serializeThrowable(status.getCause());
            trailersBuilder.add((CharSequence)GrpcHeaderNames.ARMERIA_GRPC_THROWABLEPROTO_BIN, Base64.getEncoder().encodeToString(proto.toByteArray()));
        }
        HttpHeaders additionalTrailers = ctx.additionalResponseTrailers();
        ctx.mutateAdditionalResponseTrailers(HttpHeadersBuilder::clear);
        trailersBuilder.add((Iterable)additionalTrailers);
        return trailersBuilder.build();
    }

    HttpStreamReader messageReader() {
        return this.messageReader;
    }

    void setListener(ServerCall.Listener<I> listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"listener already set");
        this.listener = Objects.requireNonNull(listener, "listener");
    }

    @Nullable
    private static com.linecorp.armeria.common.grpc.protocol.Decompressor clientDecompressor(HttpHeaders headers, DecompressorRegistry registry) {
        String encoding = headers.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING);
        if (encoding == null) {
            return ForwardingDecompressor.forGrpc((Decompressor)Codec.Identity.NONE);
        }
        Decompressor decompressor = registry.lookupDecompressor(encoding);
        if (decompressor != null) {
            return ForwardingDecompressor.forGrpc(decompressor);
        }
        return ForwardingDecompressor.forGrpc((Decompressor)Codec.Identity.NONE);
    }
}

