/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class HandlerRegistry {
    private final List<ServerServiceDefinition> services;
    private final Map<String, ServerMethodDefinition<?, ?>> methods;

    private HandlerRegistry(List<ServerServiceDefinition> services, Map<String, ServerMethodDefinition<?, ?>> methods) {
        this.services = Objects.requireNonNull(services, "services");
        this.methods = Objects.requireNonNull(methods, "methods");
    }

    @Nullable
    ServerMethodDefinition<?, ?> lookupMethod(String methodName) {
        return this.methods.get(methodName);
    }

    List<ServerServiceDefinition> services() {
        return this.services;
    }

    Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.methods;
    }

    static class Builder {
        private final HashMap<String, ServerServiceDefinition> services = new HashMap();

        Builder() {
        }

        Builder addService(ServerServiceDefinition service) {
            this.services.put(service.getServiceDescriptor().getName(), service);
            return this;
        }

        HandlerRegistry build() {
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            for (ServerServiceDefinition service : this.services.values()) {
                for (ServerMethodDefinition method : service.getMethods()) {
                    mapBuilder.put((Object)method.getMethodDescriptor().getFullMethodName(), (Object)method);
                }
            }
            return new HandlerRegistry((List)ImmutableList.copyOf(this.services.values()), (Map)mapBuilder.build());
        }
    }
}

