/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractUnframedGrpcService
extends SimpleDecoratingHttpService
implements GrpcService {
    private final GrpcService delegate;
    private final UnframedGrpcErrorHandler unframedGrpcErrorHandler;

    AbstractUnframedGrpcService(GrpcService delegate, UnframedGrpcErrorHandler unframedGrpcErrorHandler) {
        super((HttpService)delegate);
        this.delegate = delegate;
        this.unframedGrpcErrorHandler = Objects.requireNonNull(unframedGrpcErrorHandler, "unframedGrpcErrorHandler");
    }

    public Set<Route> routes() {
        return this.delegate.routes();
    }

    @Override
    public boolean isFramed() {
        return false;
    }

    @Override
    public Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.delegate.methods();
    }

    @Override
    public List<ServerServiceDefinition> services() {
        return this.delegate.services();
    }

    @Override
    public Set<SerializationFormat> supportedSerializationFormats() {
        return this.delegate.supportedSerializationFormats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void frameAndServe(Service<HttpRequest, HttpResponse> delegate, ServiceRequestContext ctx, RequestHeaders grpcHeaders, HttpData content, CompletableFuture<HttpResponse> res) {
        HttpResponse grpcResponse;
        HttpRequest grpcRequest;
        try (ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), -1, false);){
            HttpData frame;
            boolean success = false;
            try {
                frame = framer.writePayload(content.byteBuf());
                success = true;
            }
            finally {
                if (!success) {
                    content.close();
                }
            }
            grpcRequest = HttpRequest.of((RequestHeaders)grpcHeaders, (HttpData)frame);
        }
        try {
            grpcResponse = (HttpResponse)delegate.serve(ctx, (Request)grpcRequest);
        }
        catch (Exception e) {
            res.completeExceptionally(e);
            return;
        }
        grpcResponse.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).handle((framedResponse, t) -> {
            try (SafeCloseable ignore = ctx.push();){
                if (t != null) {
                    res.completeExceptionally((Throwable)t);
                } else {
                    AbstractUnframedGrpcService.deframeAndRespond(ctx, framedResponse, res, this.unframedGrpcErrorHandler);
                }
            }
            return null;
        });
    }

    @VisibleForTesting
    static void deframeAndRespond(ServiceRequestContext ctx, AggregatedHttpResponse grpcResponse, CompletableFuture<HttpResponse> res, UnframedGrpcErrorHandler unframedGrpcErrorHandler) {
        HttpHeaders trailers = !grpcResponse.trailers().isEmpty() ? grpcResponse.trailers() : grpcResponse.headers();
        String grpcStatusCode = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        Status grpcStatus = Status.fromCodeValue((int)Integer.parseInt(grpcStatusCode));
        String grpcMessage = trailers.get((CharSequence)GrpcHeaderNames.GRPC_MESSAGE);
        if (!Strings.isNullOrEmpty((String)grpcMessage)) {
            grpcStatus = grpcStatus.withDescription(grpcMessage);
        }
        if (grpcStatus.getCode() != Status.Code.OK) {
            PooledObjects.close((Object)grpcResponse.content());
            try {
                res.complete(unframedGrpcErrorHandler.handle(ctx, grpcStatus, grpcResponse));
            }
            catch (Exception e) {
                res.completeExceptionally(e);
            }
            return;
        }
        MediaType grpcMediaType = grpcResponse.contentType();
        ResponseHeadersBuilder unframedHeaders = grpcResponse.headers().toBuilder();
        unframedHeaders.set((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcStatusCode);
        if (grpcMediaType != null) {
            if (grpcMediaType.is(GrpcSerializationFormats.PROTO.mediaType())) {
                unframedHeaders.contentType(MediaType.PROTOBUF);
            } else if (grpcMediaType.is(GrpcSerializationFormats.JSON.mediaType())) {
                unframedHeaders.contentType(MediaType.JSON_UTF_8);
            }
        }
        ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(Integer.MAX_VALUE);
        grpcResponse.toHttpResponse().decode((HttpDecoder)deframer, ctx.alloc()).subscribe(AbstractUnframedGrpcService.singleSubscriber(unframedHeaders, res), (EventExecutor)ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS});
    }

    static Subscriber<DeframedMessage> singleSubscriber(final ResponseHeadersBuilder unframedHeaders, final CompletableFuture<HttpResponse> res) {
        return new Subscriber<DeframedMessage>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(1L);
            }

            public void onNext(DeframedMessage message) {
                HttpData unframedContent = HttpData.wrap((ByteBuf)message.buf()).withEndOfStream();
                unframedHeaders.contentLength((long)unframedContent.length());
                res.complete(HttpResponse.of((ResponseHeaders)unframedHeaders.build(), (HttpData)unframedContent));
            }

            public void onError(Throwable t) {
                if (!res.isDone()) {
                    res.completeExceptionally(t);
                }
            }

            public void onComplete() {
                if (!res.isDone()) {
                    res.complete(HttpResponse.of((ResponseHeaders)unframedHeaders.build()));
                }
            }
        };
    }
}

