/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.GrpcStatusFunction;
import com.linecorp.armeria.common.grpc.ThrowableProto;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcWebTrailers;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.grpc.ForwardingCompressor;
import com.linecorp.armeria.internal.common.grpc.ForwardingDecompressor;
import com.linecorp.armeria.internal.common.grpc.GrpcLogUtil;
import com.linecorp.armeria.internal.common.grpc.GrpcMessageMarshaller;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.common.grpc.HttpStreamDeframer;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import com.linecorp.armeria.internal.common.grpc.TransportStatusListener;
import com.linecorp.armeria.internal.common.grpc.protocol.Base64DecoderUtil;
import com.linecorp.armeria.internal.common.grpc.protocol.GrpcTrailersUtil;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.util.concurrent.MoreExecutors;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.unsafe.grpc.GrpcUnsafeBufferUtil;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.StatusException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArmeriaServerCall<I, O>
extends ServerCall<I, O>
implements Subscriber<DeframedMessage>,
TransportStatusListener {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaServerCall.class);
    private static final AtomicIntegerFieldUpdater<ArmeriaServerCall> pendingMessagesUpdater = AtomicIntegerFieldUpdater.newUpdater(ArmeriaServerCall.class, "pendingMessages");
    private static final Splitter ACCEPT_ENCODING_SPLITTER = Splitter.on((char)',').trimResults();
    private final MethodDescriptor<I, O> method;
    private final String simpleMethodName;
    private final StreamMessage<DeframedMessage> deframedRequest;
    private final ArmeriaMessageFramer responseFramer;
    private final HttpResponseWriter res;
    private final CompressorRegistry compressorRegistry;
    private final ServiceRequestContext ctx;
    private final SerializationFormat serializationFormat;
    private final GrpcMessageMarshaller<I, O> marshaller;
    private final boolean unsafeWrapRequestBuffers;
    private final ResponseHeaders defaultHeaders;
    @Nullable
    private final Executor blockingExecutor;
    @Nullable
    private final GrpcStatusFunction statusFunction;
    @Nullable
    private ServerCall.Listener<I> listener;
    @Nullable
    private ResponseHeaders responseHeaders;
    @Nullable
    private O firstResponse;
    @Nullable
    private final String clientAcceptEncoding;
    @Nullable
    private Compressor compressor;
    @Nullable
    private Subscription upstream;
    private boolean messageCompression = true;
    private boolean messageReceived;
    private volatile boolean cancelled;
    private volatile boolean clientStreamClosed;
    private volatile boolean listenerClosed;
    private boolean closeCalled;
    private int pendingRequests;
    private volatile int pendingMessages;

    ArmeriaServerCall(HttpRequest req, MethodDescriptor<I, O> method, String simpleMethodName, CompressorRegistry compressorRegistry, DecompressorRegistry decompressorRegistry, HttpResponseWriter res, int maxRequestMessageLength, int maxResponseMessageLength, ServiceRequestContext ctx, SerializationFormat serializationFormat, @Nullable GrpcJsonMarshaller jsonMarshaller, boolean unsafeWrapRequestBuffers, boolean useBlockingTaskExecutor, ResponseHeaders defaultHeaders, @Nullable GrpcStatusFunction statusFunction) {
        Objects.requireNonNull(req, "req");
        this.method = Objects.requireNonNull(method, "method");
        this.simpleMethodName = Objects.requireNonNull(simpleMethodName, "simpleMethodName");
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        this.defaultHeaders = Objects.requireNonNull(defaultHeaders, "defaultHeaders");
        boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(serializationFormat);
        Objects.requireNonNull(decompressorRegistry, "decompressorRegistry");
        RequestHeaders clientHeaders = req.headers();
        ByteBufAllocator alloc = ctx.alloc();
        HttpStreamDeframer requestDeframer = new HttpStreamDeframer(decompressorRegistry, (RequestContext)ctx, this, statusFunction, maxRequestMessageLength).decompressor(ArmeriaServerCall.clientDecompressor((HttpHeaders)clientHeaders, decompressorRegistry));
        this.deframedRequest = req.decode((HttpDecoder)requestDeframer, alloc, Base64DecoderUtil.byteBufConverter((ByteBufAllocator)alloc, (boolean)grpcWebText));
        requestDeframer.setDeframedStreamMessage(this.deframedRequest);
        this.responseFramer = new ArmeriaMessageFramer(alloc, maxResponseMessageLength, grpcWebText);
        this.res = Objects.requireNonNull(res, "res");
        this.compressorRegistry = Objects.requireNonNull(compressorRegistry, "compressorRegistry");
        this.clientAcceptEncoding = Strings.emptyToNull((String)clientHeaders.get((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING));
        this.marshaller = new GrpcMessageMarshaller<I, O>(alloc, serializationFormat, method, jsonMarshaller, unsafeWrapRequestBuffers);
        this.unsafeWrapRequestBuffers = unsafeWrapRequestBuffers;
        this.blockingExecutor = useBlockingTaskExecutor ? MoreExecutors.newSequentialExecutor((Executor)ctx.blockingTaskExecutor()) : null;
        this.statusFunction = statusFunction;
        res.whenComplete().handle((unused, t) -> {
            ContextAwareEventLoop eventLoop = ctx.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.maybeCancel();
            } else {
                eventLoop.execute(this::maybeCancel);
            }
            return null;
        });
    }

    private void maybeCancel() {
        if (!this.closeCalled) {
            this.cancelled = true;
            try (SafeCloseable ignore = this.ctx.push();){
                this.close(Status.CANCELLED, new Metadata());
            }
        }
    }

    public void request(int numMessages) {
        if (this.ctx.eventLoop().inEventLoop()) {
            if (this.upstream == null) {
                this.pendingRequests += numMessages;
            } else {
                this.upstream.request((long)numMessages);
            }
        } else {
            this.ctx.eventLoop().execute(() -> this.request(numMessages));
        }
    }

    public void sendHeaders(Metadata metadata) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doSendHeaders(metadata);
        } else {
            this.ctx.eventLoop().execute(() -> this.doSendHeaders(metadata));
        }
    }

    private void doSendHeaders(Metadata metadata) {
        if (this.cancelled) {
            return;
        }
        Preconditions.checkState((this.responseHeaders == null ? 1 : 0) != 0, (Object)"sendHeaders already called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        if (this.compressor == null || !this.messageCompression || this.clientAcceptEncoding == null) {
            this.compressor = Codec.Identity.NONE;
        } else {
            List acceptedEncodingsList = ACCEPT_ENCODING_SPLITTER.splitToList((CharSequence)this.clientAcceptEncoding);
            if (!acceptedEncodingsList.contains(this.compressor.getMessageEncoding())) {
                this.compressor = Codec.Identity.NONE;
            }
        }
        this.responseFramer.setCompressor(ForwardingCompressor.forGrpc(this.compressor));
        ResponseHeaders headers = this.defaultHeaders;
        if (this.compressor != Codec.Identity.NONE || InternalMetadata.headerCount((Metadata)metadata) > 0) {
            headers = headers.withMutations(builder -> {
                if (this.compressor != Codec.Identity.NONE) {
                    builder.set((CharSequence)GrpcHeaderNames.GRPC_ENCODING, this.compressor.getMessageEncoding());
                }
                MetadataUtil.fillHeaders(metadata, builder);
            });
        }
        this.responseHeaders = headers;
    }

    public void sendMessage(O message) {
        pendingMessagesUpdater.incrementAndGet(this);
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doSendMessage(message);
        } else {
            this.ctx.eventLoop().execute(() -> this.doSendMessage(message));
        }
    }

    private void doSendMessage(O message) {
        if (this.cancelled) {
            return;
        }
        Preconditions.checkState((this.responseHeaders != null ? 1 : 0) != 0, (Object)"sendHeaders has not been called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        if (this.firstResponse == null) {
            if (!this.res.tryWrite((Object)this.responseHeaders)) {
                this.maybeCancel();
                return;
            }
            this.firstResponse = message;
        }
        try {
            if (this.res.tryWrite((Object)this.responseFramer.writePayload(this.marshaller.serializeResponse(message)))) {
                if (!this.method.getType().serverSendsOneMessage()) {
                    this.res.whenConsumed().thenRun(() -> {
                        if (!this.closeCalled && pendingMessagesUpdater.decrementAndGet(this) == 0) {
                            if (this.blockingExecutor != null) {
                                this.blockingExecutor.execute(this::invokeOnReady);
                            } else {
                                this.invokeOnReady();
                            }
                        }
                    });
                }
            } else {
                this.maybeCancel();
            }
        }
        catch (Throwable e) {
            this.close(e, new Metadata());
        }
    }

    private void invokeOnReady() {
        try {
            if (this.listener != null) {
                this.listener.onReady();
            }
        }
        catch (Throwable t) {
            this.close(t, new Metadata());
        }
    }

    public boolean isReady() {
        return !this.closeCalled && this.pendingMessages == 0;
    }

    public void close(Status status, Metadata metadata) {
        this.close0(GrpcStatus.fromStatusFunction(this.statusFunction, (RequestContext)this.ctx, status, metadata), metadata);
    }

    private void close(Throwable exception, Metadata metadata) {
        this.close0(GrpcStatus.fromThrowable(this.statusFunction, (RequestContext)this.ctx, exception, metadata), metadata);
    }

    private void close0(Status status, Metadata metadata) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doClose(status, metadata);
        } else {
            this.ctx.eventLoop().execute(() -> this.doClose(status, metadata));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(Status status, Metadata metadata) {
        boolean trailersOnly;
        if (this.cancelled) {
            this.closeListener(status, false, true);
            return;
        }
        if (status.getCode() == Status.Code.CANCELLED && status.getCause() instanceof ClosedStreamException) {
            this.closeListener(status, false, true);
            return;
        }
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call already closed");
        this.closeCalled = true;
        boolean completed = true;
        if (status.getCode() == Status.Code.CANCELLED && status.getCause() instanceof RequestTimeoutException) {
            completed = false;
        } else if (status.isOk() && this.method.getType().serverSendsOneMessage() && this.firstResponse == null) {
            String description = "Completed without a response";
            logger.warn("{} {} status: {}, metadata: {}", new Object[]{this.ctx, "Completed without a response", status, metadata});
            status = Status.CANCELLED.withDescription("Completed without a response");
            completed = false;
        }
        if (this.firstResponse != null) {
            trailersOnly = false;
        } else if (!status.isOk() || this.responseHeaders == null) {
            trailersOnly = true;
        } else {
            assert (!this.method.getType().serverSendsOneMessage());
            if (this.res.tryWrite((Object)this.responseHeaders)) {
                trailersOnly = false;
            } else {
                this.closeListener(status, false, true);
                return;
            }
        }
        HttpHeadersBuilder defaultTrailers = trailersOnly ? this.defaultHeaders.toBuilder() : HttpHeaders.builder();
        HttpHeaders trailers = ArmeriaServerCall.statusToTrailers(this.ctx, defaultTrailers, status, metadata);
        this.ctx.logBuilder().responseContent((Object)GrpcLogUtil.rpcResponse(status, this.firstResponse), null);
        try {
            if (!trailersOnly && GrpcSerializationFormats.isGrpcWeb(this.serializationFormat)) {
                GrpcWebTrailers.set((RequestContext)this.ctx, (HttpHeaders)trailers);
                ByteBuf serialized = GrpcTrailersUtil.serializeTrailersAsMessage((ByteBufAllocator)this.ctx.alloc(), (HttpHeaders)trailers);
                if (this.res.tryWrite((Object)this.responseFramer.writePayload(serialized, true))) {
                    this.res.close();
                }
            } else if (this.res.tryWrite((Object)trailers)) {
                this.res.close();
            }
        }
        finally {
            this.closeListener(status, completed, false);
        }
    }

    @VisibleForTesting
    boolean isCloseCalled() {
        return this.closeCalled;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public synchronized void setMessageCompression(boolean messageCompression) {
        this.responseFramer.setMessageCompression(messageCompression);
        this.messageCompression = messageCompression;
    }

    public synchronized void setCompression(String compressorName) {
        Preconditions.checkState((this.responseHeaders == null ? 1 : 0) != 0, (Object)"sendHeaders has been called");
        this.compressor = this.compressorRegistry.lookupCompressor(compressorName);
        Preconditions.checkArgument((this.compressor != null ? 1 : 0) != 0, (String)"Unable to find compressor by name %s", (Object)compressorName);
        this.responseFramer.setCompressor(ForwardingCompressor.forGrpc(this.compressor));
    }

    public MethodDescriptor<I, O> getMethodDescriptor() {
        return this.method;
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription");
        this.upstream = subscription;
        if (this.pendingRequests > 0) {
            this.upstream.request((long)this.pendingRequests);
            this.pendingRequests = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(DeframedMessage message) {
        try {
            ByteBuf buf = message.buf();
            boolean success = false;
            try {
                if (this.messageReceived && this.method.getType() == MethodDescriptor.MethodType.UNARY) {
                    this.closeListener(Status.INTERNAL.withDescription("More than one request messages for unary call or server streaming call"), false, true);
                    return;
                }
                this.messageReceived = true;
                if (this.closeCalled) {
                    return;
                }
                success = true;
            }
            finally {
                if (buf != null && !success) {
                    buf.release();
                }
            }
            boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(this.serializationFormat);
            I request = this.marshaller.deserializeRequest(message, grpcWebText);
            if (!this.ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
                this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method, this.simpleMethodName, request), null);
            }
            if (this.unsafeWrapRequestBuffers && buf != null && !grpcWebText) {
                GrpcUnsafeBufferUtil.storeBuffer(buf, request, (RequestContext)this.ctx);
            }
            if (this.blockingExecutor != null) {
                this.blockingExecutor.execute(() -> this.invokeOnMessage(request));
            } else {
                this.invokeOnMessage(request);
            }
        }
        catch (Throwable e) {
            this.upstream.cancel();
            this.close(e, new Metadata());
        }
    }

    private void invokeOnMessage(I request) {
        try (SafeCloseable ignored = this.ctx.push();){
            assert (this.listener != null);
            this.listener.onMessage(request);
        }
        catch (Throwable t) {
            this.upstream.cancel();
            this.close(t, new Metadata());
        }
    }

    public void onComplete() {
        this.clientStreamClosed = true;
        if (!this.closeCalled) {
            if (!this.ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
                this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method, this.simpleMethodName), null);
            }
            if (this.blockingExecutor != null) {
                this.blockingExecutor.execute(this::invokeHalfClose);
            } else {
                this.invokeHalfClose();
            }
        }
    }

    public void onError(Throwable t) {
        if (!this.closeCalled && !(t instanceof AbortedStreamException)) {
            this.close(t, new Metadata());
        }
    }

    private void invokeHalfClose() {
        try (SafeCloseable ignored = this.ctx.push();){
            assert (this.listener != null);
            this.listener.onHalfClose();
        }
        catch (Throwable t) {
            this.close(t, new Metadata());
        }
    }

    @Override
    public void transportReportStatus(Status status, Metadata unused) {
        if (this.closeCalled) {
            return;
        }
        this.closeListener(status, false, true);
    }

    private void closeListener(Status newStatus, boolean completed, boolean setResponseContent) {
        if (!this.listenerClosed) {
            this.listenerClosed = true;
            if (setResponseContent) {
                this.ctx.logBuilder().responseContent((Object)GrpcLogUtil.rpcResponse(newStatus, this.firstResponse), null);
            }
            if (!this.clientStreamClosed) {
                this.clientStreamClosed = true;
                this.deframedRequest.abort();
            }
            if (completed) {
                if (this.blockingExecutor != null) {
                    this.blockingExecutor.execute(this::invokeOnComplete);
                } else {
                    this.invokeOnComplete();
                }
            } else {
                this.cancelled = true;
                if (this.blockingExecutor != null) {
                    this.blockingExecutor.execute(this::invokeOnCancel);
                } else {
                    this.invokeOnCancel();
                }
                if (!this.closeCalled) {
                    StatusException statusException = newStatus.asException();
                    Throwable cause = statusException.getCause();
                    if (cause != null) {
                        this.res.close(cause);
                    } else {
                        this.res.abort();
                    }
                }
            }
        }
    }

    private void invokeOnComplete() {
        try (SafeCloseable ignored = this.ctx.push();){
            if (this.listener != null) {
                this.listener.onComplete();
            }
        }
        catch (Throwable t) {
            logger.warn("Error in gRPC onComplete handler.", t);
        }
    }

    private void invokeOnCancel() {
        block9: {
            try (SafeCloseable ignored = this.ctx.push();){
                if (this.listener != null) {
                    this.listener.onCancel();
                }
            }
            catch (Throwable t) {
                if (this.closeCalled) break block9;
                this.close(t, new Metadata());
            }
        }
    }

    static HttpHeaders statusToTrailers(ServiceRequestContext ctx, HttpHeadersBuilder trailersBuilder, Status status, Metadata metadata) {
        GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailersBuilder, (int)status.getCode().value(), (String)status.getDescription());
        MetadataUtil.fillHeaders(metadata, trailersBuilder);
        if (ctx.config().verboseResponses() && status.getCause() != null) {
            ThrowableProto proto = GrpcStatus.serializeThrowable(status.getCause());
            trailersBuilder.add((CharSequence)GrpcHeaderNames.ARMERIA_GRPC_THROWABLEPROTO_BIN, Base64.getEncoder().encodeToString(proto.toByteArray()));
        }
        HttpHeaders additionalTrailers = ctx.additionalResponseTrailers();
        ctx.mutateAdditionalResponseTrailers(HttpHeadersBuilder::clear);
        trailersBuilder.add((Iterable)additionalTrailers);
        return trailersBuilder.build();
    }

    void setListener(ServerCall.Listener<I> listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"listener already set");
        this.listener = Objects.requireNonNull(listener, "listener");
        this.invokeOnReady();
    }

    void startDeframing() {
        assert (this.listener != null);
        this.deframedRequest.subscribe((Subscriber)this, (EventExecutor)this.ctx.eventLoop(), new SubscriptionOption[]{SubscriptionOption.WITH_POOLED_OBJECTS});
    }

    @Nullable
    private static com.linecorp.armeria.common.grpc.protocol.Decompressor clientDecompressor(HttpHeaders headers, DecompressorRegistry registry) {
        String encoding = headers.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING);
        if (encoding == null) {
            return ForwardingDecompressor.forGrpc((Decompressor)Codec.Identity.NONE);
        }
        Decompressor decompressor = registry.lookupDecompressor(encoding);
        if (decompressor != null) {
            return ForwardingDecompressor.forGrpc(decompressor);
        }
        return ForwardingDecompressor.forGrpc((Decompressor)Codec.Identity.NONE);
    }
}

