/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.Client;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.SimpleDecoratingHttpClient;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

final class CallCredentialsDecoratingClient
extends SimpleDecoratingHttpClient {
    private final CallCredentials credentials;
    private final MethodDescriptor<?, ?> method;
    private final String authority;

    CallCredentialsDecoratingClient(HttpClient delegate, CallCredentials credentials, MethodDescriptor<?, ?> method, String authority) {
        super(delegate);
        this.credentials = credentials;
        this.method = method;
        this.authority = authority;
    }

    public HttpResponse execute(final ClientRequestContext ctx, final HttpRequest req) {
        final CompletableFuture response = new CompletableFuture();
        CallCredentials.RequestInfo requestInfo = new CallCredentials.RequestInfo(){

            public MethodDescriptor<?, ?> getMethodDescriptor() {
                return CallCredentialsDecoratingClient.this.method;
            }

            public SecurityLevel getSecurityLevel() {
                return ctx.sessionProtocol().isTls() ? SecurityLevel.PRIVACY_AND_INTEGRITY : SecurityLevel.NONE;
            }

            public String getAuthority() {
                return CallCredentialsDecoratingClient.this.authority;
            }

            public Attributes getTransportAttrs() {
                return Attributes.EMPTY;
            }
        };
        this.credentials.applyRequestMetadata(requestInfo, (Executor)CommonPools.blockingTaskExecutor(), new CallCredentials.MetadataApplier(){

            public void apply(Metadata metadata) {
                ctx.mutateAdditionalRequestHeaders(headers -> MetadataUtil.fillHeaders(metadata, headers));
                try {
                    response.complete((HttpResponse)((Client)CallCredentialsDecoratingClient.this.unwrap()).execute(ctx, (Request)req));
                }
                catch (Exception e) {
                    response.completeExceptionally(e);
                }
            }

            public void fail(Status status) {
                response.completeExceptionally((Throwable)status.asRuntimeException());
            }
        });
        return HttpResponse.from(response);
    }
}

