/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.grpc.GrpcClientStubFactory;
import com.linecorp.armeria.internal.client.grpc.GrpcClientFactoryUtil;
import io.grpc.Channel;
import io.grpc.ServiceDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ScalaPbGrpcClientStubFactory
implements GrpcClientStubFactory {
    @Override
    public ServiceDescriptor findServiceDescriptor(Class<?> clientType) {
        Class<?> stubClass = clientType.getEnclosingClass();
        if (stubClass == null) {
            return null;
        }
        try {
            Method method = stubClass.getDeclaredMethod("SERVICE", new Class[0]);
            return (ServiceDescriptor)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public Object newClientStub(Class<?> clientType, Channel channel) {
        Method stubFactoryMethod = GrpcClientFactoryUtil.findStubFactoryMethod(clientType);
        try {
            return stubFactoryMethod.invoke(null, channel);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw GrpcClientFactoryUtil.newClientStubCreationException(e);
        }
    }
}

