/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.UnframedGrpcStatusMappingFunction;
import io.grpc.Status;
import java.util.Objects;

@FunctionalInterface
public interface UnframedGrpcErrorHandler {
    public static UnframedGrpcErrorHandler of() {
        return UnframedGrpcErrorHandler.of(UnframedGrpcStatusMappingFunction.of());
    }

    public static UnframedGrpcErrorHandler of(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        UnframedGrpcStatusMappingFunction mappingFunction = Objects.requireNonNull(statusMappingFunction, "statusMappingFunction").orElse(UnframedGrpcStatusMappingFunction.of());
        return (ctx, status, response) -> {
            MediaType grpcMediaType = response.contentType();
            if (grpcMediaType != null && grpcMediaType.isJson()) {
                return UnframedGrpcErrorHandler.ofJson(mappingFunction).handle(ctx, status, response);
            }
            return UnframedGrpcErrorHandler.ofPlainText(mappingFunction).handle(ctx, status, response);
        };
    }

    public static UnframedGrpcErrorHandler ofJson() {
        return UnframedGrpcErrorHandler.ofJson(UnframedGrpcStatusMappingFunction.of());
    }

    public static UnframedGrpcErrorHandler ofJson(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        UnframedGrpcStatusMappingFunction mappingFunction = Objects.requireNonNull(statusMappingFunction, "statusMappingFunction").orElse(UnframedGrpcStatusMappingFunction.of());
        return (ctx, status, response) -> {
            Status.Code grpcCode = status.getCode();
            String grpcMessage = status.getDescription();
            ImmutableMap message = grpcMessage != null ? ImmutableMap.of((Object)"grpc-code", (Object)grpcCode.name(), (Object)"message", (Object)grpcMessage) : ImmutableMap.of((Object)"grpc-code", (Object)grpcCode.name());
            RequestLogAccess log = ctx.log();
            Throwable cause = log.isAvailable(RequestLogProperty.RESPONSE_CAUSE) ? log.partial().responseCause() : null;
            HttpStatus httpStatus = mappingFunction.apply(ctx, status, cause);
            ResponseHeaders responseHeaders = ResponseHeaders.builder((HttpStatus)httpStatus).contentType(MediaType.JSON_UTF_8).addInt((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcCode.value()).build();
            return HttpResponse.ofJson((ResponseHeaders)responseHeaders, (Object)message);
        };
    }

    public static UnframedGrpcErrorHandler ofPlainText() {
        return UnframedGrpcErrorHandler.ofPlainText(UnframedGrpcStatusMappingFunction.of());
    }

    public static UnframedGrpcErrorHandler ofPlainText(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        UnframedGrpcStatusMappingFunction mappingFunction = Objects.requireNonNull(statusMappingFunction, "statusMappingFunction").orElse(UnframedGrpcStatusMappingFunction.of());
        return (ctx, status, response) -> {
            RequestLogAccess log;
            Status.Code grpcCode = status.getCode();
            StringBuilder message = new StringBuilder("grpc-code: " + grpcCode.name());
            String grpcMessage = status.getDescription();
            if (grpcMessage != null) {
                message.append(", ").append(grpcMessage);
            }
            Throwable cause = (log = ctx.log()).isAvailable(RequestLogProperty.RESPONSE_CAUSE) ? log.partial().responseCause() : null;
            HttpStatus httpStatus = mappingFunction.apply(ctx, status, cause);
            ResponseHeaders responseHeaders = ResponseHeaders.builder((HttpStatus)httpStatus).contentType(MediaType.PLAIN_TEXT_UTF_8).addInt((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcCode.value()).build();
            return HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)HttpData.ofUtf8((String)message.toString()));
        };
    }

    public HttpResponse handle(ServiceRequestContext var1, Status var2, AggregatedHttpResponse var3);
}

