/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.grpc.FramedGrpcService;
import com.linecorp.armeria.server.grpc.GrpcService;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

final class GrpcDecoratingService
extends SimpleDecoratingHttpService
implements GrpcService {
    private final GrpcService delegate;
    private final Map<String, HttpService> pathToDecorators;
    private final Map<String, HttpService> methodToDecorators;
    private final boolean lookupMethodFromAttribute;

    GrpcDecoratingService(GrpcService delegate, Map<String, HttpService> pathToDecorators, Map<String, HttpService> methodToDecorators, boolean lookupMethodFromAttribute) {
        super((HttpService)delegate);
        this.delegate = delegate;
        this.pathToDecorators = pathToDecorators;
        this.methodToDecorators = methodToDecorators;
        this.lookupMethodFromAttribute = lookupMethodFromAttribute;
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpService decoratedService = this.lookup(ctx);
        if (decoratedService != null) {
            return decoratedService.serve(ctx, req);
        }
        String path = ctx.mappedPath();
        decoratedService = this.pathToDecorators.get(path);
        if (decoratedService != null) {
            return decoratedService.serve(ctx, req);
        }
        return this.delegate.serve(ctx, req);
    }

    public Set<Route> routes() {
        return this.delegate.routes();
    }

    @Override
    public boolean isFramed() {
        return this.delegate.isFramed();
    }

    @Override
    public List<ServerServiceDefinition> services() {
        return this.delegate.services();
    }

    @Override
    public Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute() {
        return this.delegate.methodsByRoute();
    }

    @Override
    public Set<SerializationFormat> supportedSerializationFormats() {
        return this.delegate.supportedSerializationFormats();
    }

    @Nullable
    private HttpService lookup(ServiceRequestContext ctx) {
        ServerMethodDefinition method;
        ServerMethodDefinition serverMethodDefinition = method = this.lookupMethodFromAttribute ? (ServerMethodDefinition)ctx.attr(FramedGrpcService.RESOLVED_GRPC_METHOD) : null;
        if (method == null || method.getMethodDescriptor() == null) {
            return null;
        }
        return this.methodToDecorators.get(method.getMethodDescriptor().getFullMethodName());
    }
}

