/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimaps;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.GrpcHealthCheckServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthCheckUpdateListener;
import com.linecorp.armeria.server.healthcheck.HealthChecker;
import com.linecorp.armeria.server.healthcheck.ListenableHealthChecker;
import com.linecorp.armeria.server.healthcheck.SettableHealthChecker;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.health.v1.HealthCheckRequest;
import io.grpc.health.v1.HealthCheckResponse;
import io.grpc.health.v1.HealthGrpc;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcHealthCheckService
extends HealthGrpc.HealthImplBase {
    private static final Logger logger = LoggerFactory.getLogger(GrpcHealthCheckService.class);
    private static final HealthCheckResponse SERVING_RESPONSE = HealthCheckResponse.newBuilder().setStatus(HealthCheckResponse.ServingStatus.SERVING).build();
    private static final HealthCheckResponse NOT_SERVING_RESPONSE = HealthCheckResponse.newBuilder().setStatus(HealthCheckResponse.ServingStatus.NOT_SERVING).build();
    private static final HealthCheckResponse SERVICE_UNKNOWN_RESPONSE = HealthCheckResponse.newBuilder().setStatus(HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN).build();
    private static final String EMPTY_SERVICE = "";
    private final SettableHealthChecker serverHealth;
    private final Set<ListenableHealthChecker> serverHealthCheckers;
    private final Map<String, ListenableHealthChecker> grpcServiceHealthCheckers;
    private final Multimap<String, StreamObserver<HealthCheckResponse>> watchers = Multimaps.newSetMultimap(new HashMap(), Sets::newIdentityHashSet);
    private boolean serviceAdded;

    public static GrpcHealthCheckService of(ListenableHealthChecker ... healthCheckers) {
        return GrpcHealthCheckService.builder().checkers(healthCheckers).build();
    }

    public static GrpcHealthCheckService of(Iterable<? extends ListenableHealthChecker> healthCheckers) {
        return GrpcHealthCheckService.builder().checkers(healthCheckers).build();
    }

    public static GrpcHealthCheckServiceBuilder builder() {
        return new GrpcHealthCheckServiceBuilder();
    }

    private static HealthCheckResponse getHealthCheckResponse(HealthCheckResponse.ServingStatus status) {
        switch (status) {
            case SERVING: {
                return SERVING_RESPONSE;
            }
            case NOT_SERVING: {
                return NOT_SERVING_RESPONSE;
            }
            case SERVICE_UNKNOWN: {
                return SERVICE_UNKNOWN_RESPONSE;
            }
        }
        throw new IllegalArgumentException("Invalid status:" + status);
    }

    private static StatusRuntimeException getNotFoundStatus(String service) {
        return Status.NOT_FOUND.withDescription(String.format("The service name(%s) is not registered in this service", service)).asRuntimeException();
    }

    GrpcHealthCheckService(Set<ListenableHealthChecker> serverHealthCheckers, Map<String, ListenableHealthChecker> grpcServiceHealthCheckers, List<HealthCheckUpdateListener> updateListeners) {
        this.serverHealth = new SettableHealthChecker(false);
        this.serverHealthCheckers = ImmutableSet.builder().add((Object)this.serverHealth).addAll(serverHealthCheckers).build();
        this.grpcServiceHealthCheckers = grpcServiceHealthCheckers;
        Consumer<String> healthCheckUpdateListener = this.watcherHealthUpdater();
        this.serverHealthCheckers.forEach(lhc -> lhc.addListener(healthChecker -> healthCheckUpdateListener.accept(EMPTY_SERVICE)));
        if (!updateListeners.isEmpty()) {
            this.addServerHealthUpdateListener(updateListeners);
        }
        grpcServiceHealthCheckers.forEach((serviceName, lhc) -> lhc.addListener(healthChecker -> healthCheckUpdateListener.accept((String)serviceName)));
    }

    public void check(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        String service = (String)MoreObjects.firstNonNull((Object)request.getService(), (Object)EMPTY_SERVICE);
        HealthCheckResponse.ServingStatus status = this.checkServingStatus(service);
        if (status == HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN) {
            responseObserver.onError((Throwable)GrpcHealthCheckService.getNotFoundStatus(service));
            return;
        }
        responseObserver.onNext((Object)GrpcHealthCheckService.getHealthCheckResponse(status));
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watch(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        ServiceRequestContext.current().clearRequestTimeout();
        String service = (String)MoreObjects.firstNonNull((Object)request.getService(), (Object)EMPTY_SERVICE);
        Multimap<String, StreamObserver<HealthCheckResponse>> multimap = this.watchers;
        synchronized (multimap) {
            HealthCheckResponse.ServingStatus status = this.checkServingStatus(service);
            if (status == HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN) {
                responseObserver.onError((Throwable)GrpcHealthCheckService.getNotFoundStatus(service));
                return;
            }
            HealthCheckResponse response = GrpcHealthCheckService.getHealthCheckResponse(status);
            responseObserver.onNext((Object)response);
            this.watchers.put((Object)service, responseObserver);
        }
        ((ServerCallStreamObserver)responseObserver).setOnCancelHandler(() -> {
            Multimap<String, StreamObserver<HealthCheckResponse>> multimap = this.watchers;
            synchronized (multimap) {
                this.watchers.get((Object)service).remove(responseObserver);
            }
        });
    }

    void serviceAdded(ServiceConfig cfg) {
        if (this.serviceAdded) {
            return;
        }
        this.serviceAdded = true;
        Server server = cfg.server();
        server.addListener((ServerListener)new ServerListenerAdapter(){

            public void serverStarted(Server server) {
                GrpcHealthCheckService.this.serverHealth.setHealthy(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverStopping(Server server) {
                GrpcHealthCheckService.this.serverHealth.setHealthy(false);
                Multimap multimap = GrpcHealthCheckService.this.watchers;
                synchronized (multimap) {
                    GrpcHealthCheckService.this.watchers.values().forEach(StreamObserver::onCompleted);
                    GrpcHealthCheckService.this.watchers.clear();
                }
            }
        });
    }

    @VisibleForTesting
    HealthCheckResponse.ServingStatus checkServingStatus(String serviceName) {
        if (!this.isServerHealthy()) {
            return HealthCheckResponse.ServingStatus.NOT_SERVING;
        }
        if (Strings.isNullOrEmpty((String)serviceName)) {
            return HealthCheckResponse.ServingStatus.SERVING;
        }
        ListenableHealthChecker listenableHealthChecker = this.grpcServiceHealthCheckers.get(serviceName);
        if (listenableHealthChecker == null) {
            return HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN;
        }
        if (listenableHealthChecker.isHealthy()) {
            return HealthCheckResponse.ServingStatus.SERVING;
        }
        return HealthCheckResponse.ServingStatus.NOT_SERVING;
    }

    @VisibleForTesting
    void changeServerStatus(boolean isHealthy) {
        this.serverHealth.setHealthy(isHealthy);
    }

    private void addServerHealthUpdateListener(List<HealthCheckUpdateListener> updateListeners) {
        this.serverHealthCheckers.forEach(serverHealthChecker -> serverHealthChecker.addListener(healthChecker -> updateListeners.forEach(updateListener -> {
            try {
                updateListener.healthUpdated(healthChecker.isHealthy());
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception from HealthCheckUpdateListener.healthUpdated():", t);
            }
        })));
    }

    private Consumer<String> watcherHealthUpdater() {
        return serviceName -> {
            Multimap<String, StreamObserver<HealthCheckResponse>> multimap = this.watchers;
            synchronized (multimap) {
                HealthCheckResponse.ServingStatus status = this.checkServingStatus((String)serviceName);
                HealthCheckResponse healthCheckResponse = GrpcHealthCheckService.getHealthCheckResponse(status);
                this.watchers.get(serviceName).forEach(streamObserver -> streamObserver.onNext((Object)healthCheckResponse));
            }
        };
    }

    private boolean isServerHealthy() {
        for (HealthChecker healthChecker : this.serverHealthCheckers) {
            if (healthChecker.isHealthy()) continue;
            return false;
        }
        return true;
    }
}

