/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.AbstractUnframedGrpcService;
import com.linecorp.armeria.server.grpc.FramedGrpcService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HandlerRegistry;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.netty.util.concurrent.EventExecutor;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

final class UnframedGrpcService
extends AbstractUnframedGrpcService {
    private final HandlerRegistry registry;

    UnframedGrpcService(GrpcService delegate, HandlerRegistry registry, UnframedGrpcErrorHandler unframedGrpcErrorHandler) {
        super(delegate, unframedGrpcErrorHandler);
        this.registry = registry;
        Preconditions.checkArgument((boolean)delegate.isFramed(), (Object)"Decorated service must be a framed GrpcService.");
    }

    @Override
    public Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.registry.methods();
    }

    @Override
    public Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute() {
        return this.registry.methodsByRoute();
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        MediaType framedContentType;
        RequestHeaders clientHeaders = req.headers();
        MediaType contentType = clientHeaders.contentType();
        if (contentType == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        for (SerializationFormat format : GrpcSerializationFormats.values()) {
            if (!format.isAccepted(contentType)) continue;
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        ServerMethodDefinition<?, ?> method = FramedGrpcService.methodDefinition(ctx, this.registry);
        if (method == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        if (method.getMethodDescriptor().getType() != MethodDescriptor.MethodType.UNARY) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Only unary methods can be used with non-framed requests.");
        }
        RequestHeadersBuilder grpcHeaders = clientHeaders.toBuilder();
        if (contentType.is(MediaType.PROTOBUF)) {
            framedContentType = GrpcSerializationFormats.PROTO.mediaType();
        } else if (contentType.is(MediaType.JSON)) {
            framedContentType = GrpcSerializationFormats.JSON.mediaType();
        } else {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Unsupported media type. Only application/protobuf is supported.");
        }
        grpcHeaders.contentType(framedContentType);
        if (grpcHeaders.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING) != null) {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"gRPC encoding is not supported for non-framed requests.");
        }
        grpcHeaders.remove((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING);
        ctx.logBuilder().defer(new RequestLogProperty[]{RequestLogProperty.REQUEST_CONTENT, RequestLogProperty.RESPONSE_CONTENT});
        CompletableFuture responseFuture = new CompletableFuture();
        req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).handle((clientRequest, t) -> {
            try (SafeCloseable ignore = ctx.push();){
                if (t != null) {
                    responseFuture.completeExceptionally((Throwable)t);
                } else {
                    ctx.setAttr(FramedGrpcService.RESOLVED_GRPC_METHOD, (Object)method);
                    this.frameAndServe((Service<HttpRequest, HttpResponse>)((Service)this.unwrap()), ctx, grpcHeaders.build(), clientRequest.content(), responseFuture, null);
                }
            }
            return null;
        });
        return HttpResponse.from(responseFuture);
    }
}

