/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.ArmeriaRequestCoroutineContext;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.kotlin.CoroutineContextServerInterceptor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ExecutorsKt;

final class ArmeriaCoroutineContextInterceptor
extends CoroutineContextServerInterceptor {
    private final boolean useBlockingTaskExecutor;

    ArmeriaCoroutineContextInterceptor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
    }

    public CoroutineContext coroutineContext(ServerCall<?, ?> serverCall, Metadata metadata) {
        ServiceRequestContext ctx = ServiceRequestContext.current();
        ArmeriaRequestCoroutineContext coroutineContext = new ArmeriaRequestCoroutineContext(ctx);
        ScheduledExecutorService executor = this.useBlockingTaskExecutor ? ctx.blockingTaskExecutor().withoutContext() : ctx.eventLoop().withoutContext();
        return ExecutorsKt.from((ExecutorService)executor).plus((CoroutineContext)coroutineContext);
    }
}

