/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.grpc.AbstractServerCall;
import com.linecorp.armeria.server.grpc.AsyncServerInterceptor;
import io.grpc.ServerCall;
import io.netty.util.concurrent.EventExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

final class DeferredListener<I>
extends ServerCall.Listener<I> {
    private static final List<?> NOOP_TASKS = ImmutableList.of();
    @Nullable
    private final Executor blockingExecutor;
    @Nullable
    private final EventExecutor eventLoop;
    private List<Consumer<ServerCall.Listener<I>>> pendingTasks = new ArrayList<Consumer<ServerCall.Listener<I>>>();
    @Nullable
    private ServerCall.Listener<I> delegate;
    private boolean callClosed;

    DeferredListener(ServerCall<I, ?> serverCall, CompletableFuture<ServerCall.Listener<I>> listenerFuture) {
        Preconditions.checkState((boolean)(serverCall instanceof AbstractServerCall), (String)"Cannot use %s with a non-Armeria gRPC server", (Object)AsyncServerInterceptor.class.getName());
        AbstractServerCall armeriaServerCall = (AbstractServerCall)serverCall;
        this.blockingExecutor = armeriaServerCall.blockingExecutor();
        this.eventLoop = this.blockingExecutor == null ? armeriaServerCall.eventLoop() : null;
        listenerFuture.handleAsync((delegate, cause) -> {
            if (cause != null) {
                this.callClosed = true;
                armeriaServerCall.close((Throwable)cause);
                return null;
            }
            this.delegate = delegate;
            try {
                for (Consumer<ServerCall.Listener<I>> task : this.pendingTasks) {
                    task.accept((ServerCall.Listener<I>)delegate);
                }
            }
            catch (Throwable ex) {
                this.callClosed = true;
                armeriaServerCall.close(ex);
                return null;
            }
            this.pendingTasks = NOOP_TASKS;
            return null;
        }, this.sequentialExecutor());
    }

    public void onMessage(I message) {
        if (this.callClosed) {
            return;
        }
        if (this.pendingTasks == NOOP_TASKS) {
            this.delegate.onMessage(message);
        } else {
            this.maybeAddPendingTask(listener -> listener.onMessage(message));
        }
    }

    public void onHalfClose() {
        if (this.callClosed) {
            return;
        }
        if (this.pendingTasks == NOOP_TASKS) {
            this.delegate.onHalfClose();
        } else {
            this.maybeAddPendingTask(ServerCall.Listener::onHalfClose);
        }
    }

    public void onCancel() {
        if (this.callClosed) {
            return;
        }
        if (this.pendingTasks == NOOP_TASKS) {
            this.delegate.onCancel();
        } else {
            this.maybeAddPendingTask(ServerCall.Listener::onCancel);
        }
    }

    public void onComplete() {
        if (this.callClosed) {
            return;
        }
        if (this.pendingTasks == NOOP_TASKS) {
            this.delegate.onComplete();
        } else {
            this.maybeAddPendingTask(ServerCall.Listener::onComplete);
        }
    }

    public void onReady() {
        if (this.callClosed) {
            return;
        }
        if (this.pendingTasks == NOOP_TASKS) {
            this.delegate.onReady();
        } else {
            this.maybeAddPendingTask(ServerCall.Listener::onReady);
        }
    }

    private void maybeAddPendingTask(Consumer<ServerCall.Listener<I>> task) {
        if (this.eventLoop != null && this.eventLoop.inEventLoop()) {
            this.pendingTasks.add(task);
        } else {
            this.sequentialExecutor().execute(() -> {
                if (this.callClosed) {
                    return;
                }
                if (this.pendingTasks == NOOP_TASKS) {
                    task.accept(this.delegate);
                } else {
                    this.pendingTasks.add(task);
                }
            });
        }
    }

    private Executor sequentialExecutor() {
        return (Executor)MoreObjects.firstNonNull((Object)this.eventLoop, (Object)this.blockingExecutor);
    }
}

