/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcWebTrailers;
import com.linecorp.armeria.common.stream.StreamDecoder;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.internal.client.grpc.protocol.InternalGrpcWebUtil;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.grpc.ForwardingDecompressor;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class GrpcWebTrailersExtractor
implements DecoratingHttpClientFunction {
    private final int maxMessageSizeBytes;
    private final boolean grpcWebText;

    GrpcWebTrailersExtractor(int maxMessageSizeBytes, boolean grpcWebText) {
        this.maxMessageSizeBytes = maxMessageSizeBytes;
        this.grpcWebText = grpcWebText;
    }

    public HttpResponse execute(HttpClient delegate, ClientRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponse response = delegate.execute(ctx, req);
        ByteBufAllocator alloc = ctx.alloc();
        final ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(this.maxMessageSizeBytes, alloc, this.grpcWebText);
        final StreamWriter publisher = StreamMessage.streaming();
        StreamMessage deframed = publisher.decode((StreamDecoder)deframer, alloc);
        deframed.subscribe((Subscriber)new TrailersSubscriber(ctx), (EventExecutor)ctx.eventLoop());
        FilteredHttpResponse filteredHttpResponse = new FilteredHttpResponse(response, true){

            protected HttpObject filter(HttpObject obj) {
                if (obj instanceof ResponseHeaders) {
                    ResponseHeaders headers = (ResponseHeaders)obj;
                    String statusText = headers.get((CharSequence)HttpHeaderNames.STATUS);
                    if (statusText == null) {
                        publisher.close();
                        return obj;
                    }
                    if (ArmeriaHttpUtil.isInformational((String)statusText)) {
                        return obj;
                    }
                    HttpStatus status = HttpStatus.valueOf((String)statusText);
                    if (!status.equals((Object)HttpStatus.OK)) {
                        publisher.close();
                        return obj;
                    }
                    String grpcEncoding = headers.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING);
                    if (grpcEncoding != null) {
                        Decompressor decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(grpcEncoding);
                        if (decompressor == null) {
                            publisher.close();
                            return obj;
                        }
                        deframer.decompressor((com.linecorp.armeria.common.grpc.protocol.Decompressor)ForwardingDecompressor.forGrpc(decompressor));
                    }
                    return obj;
                }
                if (obj instanceof HttpData && !publisher.isComplete()) {
                    HttpData httpData = (HttpData)obj;
                    HttpData wrapped = HttpData.wrap((ByteBuf)httpData.byteBuf(ByteBufAccessMode.RETAINED_DUPLICATE));
                    boolean bl = publisher.tryWrite((Object)wrapped);
                }
                return obj;
            }
        };
        filteredHttpResponse.whenComplete().handle((unused, unused2) -> {
            publisher.close();
            return null;
        });
        return filteredHttpResponse;
    }

    private static final class TrailersSubscriber
    implements Subscriber<DeframedMessage> {
        private final ClientRequestContext ctx;

        TrailersSubscriber(ClientRequestContext ctx) {
            this.ctx = ctx;
        }

        public void onSubscribe(Subscription s) {
            s.request(Long.MAX_VALUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(DeframedMessage message) {
            if (message.isTrailer()) {
                ByteBuf buf;
                try {
                    buf = InternalGrpcWebUtil.messageBuf((DeframedMessage)message, (ByteBufAllocator)this.ctx.alloc());
                }
                catch (IOException e) {
                    return;
                }
                try {
                    HttpHeaders trailers = InternalGrpcWebUtil.parseGrpcWebTrailers((ByteBuf)buf);
                    if (trailers == null) {
                        return;
                    }
                    GrpcWebTrailers.set((RequestContext)this.ctx, (HttpHeaders)trailers);
                }
                finally {
                    buf.release();
                }
            }
            message.close();
        }

        public void onError(Throwable t) {
        }

        public void onComplete() {
        }
    }
}

