/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnsafeByteOperations;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.io.ByteStreams;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class GrpcMessageMarshaller<I, O> {
    private final ByteBufAllocator alloc;
    private final MethodDescriptor<I, O> method;
    @Nullable
    private final GrpcJsonMarshaller jsonMarshaller;
    private final MethodDescriptor.Marshaller<I> requestMarshaller;
    private final MethodDescriptor.Marshaller<O> responseMarshaller;
    private final MessageType requestType;
    private final MessageType responseType;
    private final boolean unsafeWrapDeserializedBuffer;
    private final boolean isProto;

    public GrpcMessageMarshaller(ByteBufAllocator alloc, SerializationFormat serializationFormat, MethodDescriptor<I, O> method, @Nullable GrpcJsonMarshaller jsonMarshaller, boolean unsafeWrapDeserializedBuffer) {
        this.alloc = Objects.requireNonNull(alloc, "alloc");
        this.method = Objects.requireNonNull(method, "method");
        this.unsafeWrapDeserializedBuffer = unsafeWrapDeserializedBuffer;
        Preconditions.checkArgument((!GrpcSerializationFormats.isJson(serializationFormat) || jsonMarshaller != null ? 1 : 0) != 0, (Object)"jsonMarshaller must be non-null when serializationFormat is JSON.");
        this.isProto = GrpcSerializationFormats.isProto(serializationFormat);
        this.jsonMarshaller = jsonMarshaller;
        this.requestMarshaller = method.getRequestMarshaller();
        this.responseMarshaller = method.getResponseMarshaller();
        this.requestType = GrpcMessageMarshaller.marshallerType(this.requestMarshaller);
        this.responseType = GrpcMessageMarshaller.marshallerType(this.responseMarshaller);
    }

    public ByteBuf serializeRequest(I message) throws IOException {
        switch (this.requestType) {
            case PROTOBUF: {
                MethodDescriptor.PrototypeMarshaller marshaller = (MethodDescriptor.PrototypeMarshaller)this.requestMarshaller;
                return this.serializeProto(marshaller, (Message)message);
            }
        }
        CompositeByteBuf out = this.alloc.compositeBuffer();
        try (ByteBufOutputStream os = new ByteBufOutputStream((ByteBuf)out);){
            if (this.isProto) {
                ByteStreams.copy((InputStream)this.method.streamRequest(message), (OutputStream)os);
            } else {
                this.jsonMarshaller.serializeMessage(this.requestMarshaller, message, (OutputStream)os);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I deserializeRequest(DeframedMessage message, boolean grpcWebText) throws IOException {
        InputStream messageStream = message.stream();
        ByteBuf buf = message.buf();
        if (buf != null) {
            try {
                switch (this.requestType) {
                    case PROTOBUF: {
                        Message msg;
                        MethodDescriptor.PrototypeMarshaller marshaller = (MethodDescriptor.PrototypeMarshaller)this.requestMarshaller;
                        Message message2 = msg = this.deserializeProto(marshaller, buf);
                        return (I)message2;
                    }
                }
                messageStream = new ByteBufInputStream(buf.retain(), true);
            }
            finally {
                if (!this.unsafeWrapDeserializedBuffer || grpcWebText) {
                    buf.release();
                }
            }
        }
        try (InputStream msg = messageStream;){
            if (this.isProto) {
                Object object = this.method.parseRequest(msg);
                return (I)object;
            }
            I i = this.jsonMarshaller.deserializeMessage(this.requestMarshaller, msg);
            return i;
        }
    }

    public ByteBuf serializeResponse(O message) throws IOException {
        switch (this.responseType) {
            case PROTOBUF: {
                MethodDescriptor.PrototypeMarshaller marshaller = (MethodDescriptor.PrototypeMarshaller)this.method.getResponseMarshaller();
                return this.serializeProto(marshaller, (Message)message);
            }
        }
        CompositeByteBuf out = this.alloc.compositeBuffer();
        try (ByteBufOutputStream os = new ByteBufOutputStream((ByteBuf)out);){
            if (this.isProto) {
                ByteStreams.copy((InputStream)this.method.streamResponse(message), (OutputStream)os);
            } else {
                this.jsonMarshaller.serializeMessage(this.responseMarshaller, message, (OutputStream)os);
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public O deserializeResponse(DeframedMessage message, boolean grpcWebText) throws IOException {
        InputStream messageStream = message.stream();
        ByteBuf buf = message.buf();
        if (buf != null) {
            try {
                switch (this.responseType) {
                    case PROTOBUF: {
                        Message msg;
                        MethodDescriptor.PrototypeMarshaller marshaller = (MethodDescriptor.PrototypeMarshaller)this.method.getResponseMarshaller();
                        Message message2 = msg = this.deserializeProto(marshaller, buf);
                        return (O)message2;
                    }
                }
                messageStream = new ByteBufInputStream(buf.retain(), true);
            }
            finally {
                if (!this.unsafeWrapDeserializedBuffer || grpcWebText) {
                    buf.release();
                }
            }
        }
        try (InputStream msg = messageStream;){
            if (this.isProto) {
                Object object = this.method.parseResponse(msg);
                return (O)object;
            }
            O o = this.jsonMarshaller.deserializeMessage(this.responseMarshaller, msg);
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ByteBuf serializeProto(MethodDescriptor.PrototypeMarshaller<T> marshaller, Message message) throws IOException {
        if (this.isProto) {
            int serializedSize = message.getSerializedSize();
            if (serializedSize == 0) {
                return Unpooled.EMPTY_BUFFER;
            }
            ByteBuf buf = this.alloc.buffer(serializedSize);
            boolean success = false;
            try {
                message.writeTo(CodedOutputStream.newInstance((ByteBuffer)buf.nioBuffer(0, serializedSize)));
                buf.writerIndex(serializedSize);
                success = true;
            }
            finally {
                if (!success) {
                    buf.release();
                }
            }
            return buf;
        }
        CompositeByteBuf buf = this.alloc.compositeBuffer();
        boolean success = false;
        try (ByteBufOutputStream os = new ByteBufOutputStream((ByteBuf)buf);){
            Message cast = message;
            this.jsonMarshaller.serializeMessage(marshaller, cast, (OutputStream)os);
            success = true;
        }
        finally {
            if (!success) {
                buf.release();
            }
        }
        return buf;
    }

    private <T> Message deserializeProto(MethodDescriptor.PrototypeMarshaller<T> marshaller, ByteBuf buf) throws IOException {
        Message prototype = (Message)marshaller.getMessagePrototype();
        if (this.isProto) {
            CodedInputStream stream;
            if (!buf.isReadable()) {
                return prototype.getDefaultInstanceForType();
            }
            if (this.unsafeWrapDeserializedBuffer) {
                stream = UnsafeByteOperations.unsafeWrap((ByteBuffer)buf.nioBuffer()).newCodedInput();
                stream.enableAliasing(true);
            } else {
                stream = CodedInputStream.newInstance((ByteBuffer)buf.nioBuffer());
            }
            try {
                Message msg = (Message)prototype.getParserForType().parseFrom(stream);
                try {
                    stream.checkLastTagWas(0);
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage((MessageLite)msg);
                    throw e;
                }
                return msg;
            }
            catch (InvalidProtocolBufferException e) {
                throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
            }
        }
        try (ByteBufInputStream is = new ByteBufInputStream(buf, false);){
            Message message = (Message)this.jsonMarshaller.deserializeMessage(marshaller, (InputStream)is);
            return message;
        }
    }

    private static MessageType marshallerType(MethodDescriptor.Marshaller<?> marshaller) {
        return marshaller instanceof MethodDescriptor.PrototypeMarshaller ? MessageType.PROTOBUF : MessageType.UNKNOWN;
    }

    private static enum MessageType {
        UNKNOWN,
        PROTOBUF;

    }
}

