/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.grpc;

import com.google.api.HttpRule;
import com.google.protobuf.Descriptors;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.Route;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class HttpEndpointSpecification {
    private final int order;
    private final Route route;
    private final Set<String> pathVariables;
    private final Descriptors.ServiceDescriptor serviceDescriptor;
    private final Descriptors.MethodDescriptor methodDescriptor;
    private final Map<String, Parameter> parameters;
    private final HttpRule httpRule;

    public HttpEndpointSpecification(int order, Route route, Set<String> pathVariables, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor, Map<String, Parameter> parameters, HttpRule httpRule) {
        Preconditions.checkArgument((order >= 0 ? 1 : 0) != 0, (String)"order: %s (>= 0)", (int)order);
        this.order = order;
        this.route = Objects.requireNonNull(route, "route");
        this.pathVariables = Objects.requireNonNull(pathVariables, "pathVariables");
        this.serviceDescriptor = Objects.requireNonNull(serviceDescriptor, "serviceDescriptor");
        this.methodDescriptor = Objects.requireNonNull(methodDescriptor, "methodDescriptor");
        this.parameters = Objects.requireNonNull(parameters, "parameters");
        this.httpRule = Objects.requireNonNull(httpRule, "httpRule");
    }

    HttpEndpointSpecification withRoute(Route route) {
        Objects.requireNonNull(route, "route");
        if (route == this.route) {
            return this;
        }
        return new HttpEndpointSpecification(this.order, route, this.pathVariables, this.serviceDescriptor, this.methodDescriptor, this.parameters, this.httpRule);
    }

    public int order() {
        return this.order;
    }

    public Route route() {
        return this.route;
    }

    public Set<String> pathVariables() {
        return this.pathVariables;
    }

    public Descriptors.ServiceDescriptor serviceDescriptor() {
        return this.serviceDescriptor;
    }

    public Descriptors.MethodDescriptor methodDescriptor() {
        return this.methodDescriptor;
    }

    public Map<String, Parameter> parameters() {
        return this.parameters;
    }

    public String serviceName() {
        return this.serviceDescriptor.getFullName();
    }

    public String methodName() {
        return this.methodDescriptor.getName();
    }

    public HttpRule httpRule() {
        return this.httpRule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpEndpointSpecification)) {
            return false;
        }
        HttpEndpointSpecification that = (HttpEndpointSpecification)o;
        return this.order == that.order && this.route.equals((Object)that.route) && this.pathVariables.equals(that.pathVariables) && this.serviceDescriptor.equals(that.serviceDescriptor) && this.methodDescriptor.equals(that.methodDescriptor) && this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.route, this.pathVariables, this.serviceDescriptor, this.methodDescriptor, this.parameters);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("order", this.order).add("route", (Object)this.route).add("pathVariables", this.pathVariables).add("serviceDescriptor", (Object)this.serviceDescriptor).add("methodDescriptor", (Object)this.methodDescriptor).add("parameters", this.parameters).toString();
    }

    public static class Parameter {
        private final Descriptors.FieldDescriptor.JavaType type;
        private final boolean isRepeated;

        public Parameter(Descriptors.FieldDescriptor.JavaType type, boolean isRepeated) {
            this.type = Objects.requireNonNull(type, "type");
            this.isRepeated = isRepeated;
        }

        public Descriptors.FieldDescriptor.JavaType type() {
            return this.type;
        }

        public boolean isRepeated() {
            return this.isRepeated;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Parameter)) {
                return false;
            }
            Parameter that = (Parameter)o;
            return this.type == that.type && this.isRepeated == that.isRepeated;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.isRepeated);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("isRepeated", this.isRepeated).toString();
        }
    }
}

