/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.util.StringUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class HttpJsonTranscodingPathParser {
    static List<PathSegment> parse(String path) {
        ImmutableList pathSegments;
        Objects.requireNonNull(path, "path");
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0, (Object)"path is empty.");
        Context context = new Context(path);
        Preconditions.checkArgument((context.read() == '/' ? 1 : 0) != 0, (String)"path: %s (must start with '/')", (Object)context.path());
        ImmutableList.Builder segments = ImmutableList.builder();
        segments.addAll(HttpJsonTranscodingPathParser.parseSegments(context, new Delimiters(58)));
        if (context.hasNext()) {
            Preconditions.checkArgument((context.read() == ':' ? 1 : 0) != 0, (String)"path: %s (invalid verb part at index %s)", (Object)context.path(), (int)context.index());
            segments.add((Object)new VerbPathSegment(context.readAll()));
        }
        Preconditions.checkArgument((!(pathSegments = segments.build()).isEmpty() ? 1 : 0) != 0, (String)"path: %s (must contain at least one segment)", (Object)context.path());
        return pathSegments;
    }

    private static List<PathSegment> parseSegments(Context context, Delimiters delimiters) {
        Delimiters segmentDelimiters = delimiters.withMoreCharacter(47);
        ImmutableList.Builder segments = ImmutableList.builder();
        while (context.hasNext()) {
            PathSegment parsedSegment = HttpJsonTranscodingPathParser.parseSegment(context, segmentDelimiters);
            segments.add((Object)parsedSegment);
            if (!context.hasNext()) {
                return segments.build();
            }
            char c = context.peek();
            if (delimiters.contains(c)) {
                return segments.build();
            }
            Preconditions.checkArgument((!HttpJsonTranscodingPathParser.containsDeepWildcardLiteral(parsedSegment) ? 1 : 0) != 0, (String)"path: %s (must be no more segments after '**' literal at index %s)", (Object)context.path(), (int)context.index());
            Preconditions.checkArgument((context.read() == '/' ? 1 : 0) != 0, (String)"path: %s (invalid segments part at index %s)", (Object)context.path(), (int)context.index());
        }
        return segments.build();
    }

    private static boolean containsDeepWildcardLiteral(PathSegment segment) {
        if (segment instanceof DeepWildcardPathSegment) {
            return true;
        }
        if (segment instanceof VariablePathSegment) {
            return ((VariablePathSegment)segment).valueSegments().stream().anyMatch(HttpJsonTranscodingPathParser::containsDeepWildcardLiteral);
        }
        return false;
    }

    private static PathSegment parseSegment(Context context, Delimiters delimiters) {
        char c;
        char firstCh = context.read();
        switch (firstCh) {
            case '{': {
                Delimiters variableStopBefore = new Delimiters(125);
                PathSegment segment = HttpJsonTranscodingPathParser.parseVariable(context, variableStopBefore);
                Preconditions.checkArgument((context.read() == '}' ? 1 : 0) != 0, (String)"path: %s (invalid variable part at index %s)", (Object)context.path(), (int)context.index());
                return segment;
            }
            case '*': {
                PathSegment segment;
                if (context.peek() == '*') {
                    context.read();
                    segment = new DeepWildcardPathSegment(context.nextPathVarIndex());
                } else {
                    segment = new WildcardPathSegment(context.nextPathVarIndex(), null);
                }
                Preconditions.checkArgument((!context.hasNext() || delimiters.contains(context.peek()) ? 1 : 0) != 0, (String)"path: %s (invalid wildcard part at index %s)", (Object)context.path(), (int)context.index());
                return segment;
            }
        }
        StringBuilder literalBuilder = new StringBuilder().append(firstCh);
        while (context.hasNext() && !delimiters.contains(c = context.peek())) {
            literalBuilder.append(context.read());
        }
        return new LiteralPathSegment(literalBuilder.toString());
    }

    private static PathSegment parseVariable(Context context, Delimiters delimiters) {
        StringBuilder fieldPathBuilder = new StringBuilder();
        char c = '\u0000';
        while (context.hasNext() && !delimiters.contains(c = context.peek()) && c != '=') {
            fieldPathBuilder.append(context.read());
        }
        String fieldPath = fieldPathBuilder.toString();
        Preconditions.checkArgument((!fieldPath.isEmpty() ? 1 : 0) != 0, (String)"path: %s (invalid variable part at index %s)", (Object)context.path(), (int)context.index());
        if (c == '=') {
            context.read();
            List<PathSegment> segments = HttpJsonTranscodingPathParser.parseSegments(context, delimiters);
            if (segments.size() == 1 && segments.get(0) instanceof WildcardPathSegment) {
                return new VariablePathSegment(fieldPath, (List<PathSegment>)ImmutableList.of((Object)((WildcardPathSegment)segments.get(0)).withParentFieldPath(fieldPath)));
            }
            return new VariablePathSegment(fieldPath, segments);
        }
        return new VariablePathSegment(fieldPath, (List<PathSegment>)ImmutableList.of((Object)new WildcardPathSegment(context.nextPathVarIndex(), fieldPath)));
    }

    private HttpJsonTranscodingPathParser() {
    }

    static final class Context {
        private final String path;
        private int index;
        private int pathVarIndex;

        Context(String path) {
            this.path = path;
        }

        String path() {
            return this.path;
        }

        int index() {
            return this.index;
        }

        int nextPathVarIndex() {
            return this.pathVarIndex++;
        }

        boolean hasNext() {
            return this.index < this.path.length();
        }

        char read() {
            Preconditions.checkArgument((boolean)this.hasNext(), (String)"path: %s (out of range at index %s)", (Object)this.path(), (int)this.index());
            return this.path.charAt(this.index++);
        }

        String readAll() {
            String read = this.path.substring(this.index);
            this.index = this.path.length();
            return read;
        }

        char peek() {
            return this.path.charAt(this.index);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("index", this.index).add("pathVarIndex", this.pathVarIndex).toString();
        }
    }

    static final class Delimiters {
        private final Set<Integer> characters;

        Delimiters(int ... characters) {
            this.characters = (Set)Arrays.stream(characters).boxed().collect(ImmutableSet.toImmutableSet());
        }

        private Delimiters(Set<Integer> characters) {
            this.characters = characters;
        }

        boolean contains(int ch) {
            return this.characters.contains(ch);
        }

        Delimiters withMoreCharacter(int ch) {
            return new Delimiters((Set<Integer>)ImmutableSet.builder().addAll(this.characters).add((Object)ch).build());
        }
    }

    static class VerbPathSegment
    implements PathSegment {
        private final String verb;

        VerbPathSegment(String verb) {
            this.verb = verb;
        }

        @Override
        public String segmentString(PathSegment.PathMappingType type) {
            return this.verb;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("verb", (Object)this.verb).toString();
        }
    }

    static interface PathSegment {
        public String segmentString(PathMappingType var1);

        @Nullable
        default public String pathVariable(PathMappingType type) {
            return null;
        }

        default public boolean support(PathMappingType type) {
            return true;
        }

        public static enum PathMappingType {
            PARAMETERIZED,
            GLOB;

        }
    }

    static class DeepWildcardPathSegment
    implements PathSegment {
        private final int pathVarIndex;

        DeepWildcardPathSegment(int pathVarIndex) {
            this.pathVarIndex = pathVarIndex;
        }

        @Override
        public String segmentString(PathSegment.PathMappingType type) {
            if (type == PathSegment.PathMappingType.PARAMETERIZED) {
                throw new UnsupportedOperationException("Unable to convert to ParameterizedPathMapping.");
            }
            return "**";
        }

        @Override
        public String pathVariable(PathSegment.PathMappingType type) {
            return type == PathSegment.PathMappingType.GLOB ? StringUtil.toString((int)this.pathVarIndex) : null;
        }

        @Override
        public boolean support(PathSegment.PathMappingType type) {
            return type == PathSegment.PathMappingType.GLOB;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pathVarIndex", this.pathVarIndex).toString();
        }
    }

    static class VariablePathSegment
    implements PathSegment {
        private final String fieldPath;
        private final List<PathSegment> valueSegments;

        VariablePathSegment(String fieldPath, List<PathSegment> valueSegments) {
            this.fieldPath = fieldPath;
            this.valueSegments = valueSegments;
        }

        String fieldPath() {
            return this.fieldPath;
        }

        List<PathSegment> valueSegments() {
            return this.valueSegments;
        }

        @Override
        public String segmentString(PathSegment.PathMappingType type) {
            return type == PathSegment.PathMappingType.PARAMETERIZED ? Stringifier.asParameterizedPath(this.valueSegments, false) : Stringifier.asGlobPath(this.valueSegments, false);
        }

        @Override
        public boolean support(PathSegment.PathMappingType type) {
            return this.valueSegments.stream().allMatch(segment -> segment.support(type));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fieldPath", (Object)this.fieldPath).add("valueSegments", this.valueSegments).toString();
        }
    }

    static class WildcardPathSegment
    implements PathSegment {
        private final int pathVarIndex;
        @Nullable
        private final String parentFieldPath;

        WildcardPathSegment(int pathVarIndex, @Nullable String parentFieldPath) {
            this.pathVarIndex = pathVarIndex;
            this.parentFieldPath = parentFieldPath;
        }

        @Override
        public String segmentString(PathSegment.PathMappingType type) {
            return type == PathSegment.PathMappingType.PARAMETERIZED ? ':' + this.pathVariable(type) : "*";
        }

        @Override
        public String pathVariable(PathSegment.PathMappingType type) {
            if (type == PathSegment.PathMappingType.PARAMETERIZED) {
                if (this.parentFieldPath != null) {
                    return this.parentFieldPath;
                }
                return 'p' + StringUtil.toString((int)this.pathVarIndex);
            }
            return StringUtil.toString((int)this.pathVarIndex);
        }

        WildcardPathSegment withParentFieldPath(String parentFieldPath) {
            return new WildcardPathSegment(this.pathVarIndex, parentFieldPath);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pathVarIndex", this.pathVarIndex).add("parentFieldPath", (Object)this.parentFieldPath).toString();
        }
    }

    static class LiteralPathSegment
    implements PathSegment {
        private final String literal;

        LiteralPathSegment(String literal) {
            this.literal = literal;
        }

        @Override
        public String segmentString(PathSegment.PathMappingType type) {
            return this.literal;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("literal", (Object)this.literal).toString();
        }
    }

    static final class Stringifier {
        static String asParameterizedPath(List<PathSegment> segments, boolean withLeadingSlash) {
            Objects.requireNonNull(segments, "segments");
            String path = segments.stream().map(segment -> segment.segmentString(PathSegment.PathMappingType.PARAMETERIZED)).collect(Collectors.joining("/"));
            return withLeadingSlash ? '/' + path : path;
        }

        static String asGlobPath(List<PathSegment> segments, boolean withLeadingSlash) {
            Objects.requireNonNull(segments, "segments");
            String path = segments.stream().map(segment -> segment.segmentString(PathSegment.PathMappingType.GLOB)).collect(Collectors.joining("/"));
            return withLeadingSlash ? '/' + path : path;
        }

        private Stringifier() {
        }
    }
}

