/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregationOptions;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.GrpcStatusFunction;
import com.linecorp.armeria.internal.common.HttpMessageAggregator;
import com.linecorp.armeria.internal.common.grpc.GrpcLogUtil;
import com.linecorp.armeria.internal.common.grpc.StatusAndMetadata;
import com.linecorp.armeria.internal.server.grpc.AbstractServerCall;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.UnaryMessageDeframer;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

final class UnaryServerCall<I, O>
extends AbstractServerCall<I, O> {
    private final HttpRequest req;
    private final CompletableFuture<HttpResponse> resFuture;
    private final ServiceRequestContext ctx;
    private final UnaryMessageDeframer requestDeframer;
    @Nullable
    private O responseMessage;

    UnaryServerCall(HttpRequest req, MethodDescriptor<I, O> method, String simpleMethodName, CompressorRegistry compressorRegistry, DecompressorRegistry decompressorRegistry, HttpResponse res, CompletableFuture<HttpResponse> resFuture, int maxRequestMessageLength, int maxResponseMessageLength, ServiceRequestContext ctx, SerializationFormat serializationFormat, @Nullable GrpcJsonMarshaller jsonMarshaller, boolean unsafeWrapRequestBuffers, ResponseHeaders defaultHeaders, @Nullable GrpcStatusFunction statusFunction, @Nullable Executor blockingExecutor, boolean autoCompress) {
        super(req, method, simpleMethodName, compressorRegistry, decompressorRegistry, res, maxResponseMessageLength, ctx, serializationFormat, jsonMarshaller, unsafeWrapRequestBuffers, defaultHeaders, statusFunction, blockingExecutor, autoCompress);
        Objects.requireNonNull(req, "req");
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(serializationFormat);
        Objects.requireNonNull(decompressorRegistry, "decompressorRegistry");
        RequestHeaders clientHeaders = req.headers();
        this.requestDeframer = new UnaryMessageDeframer(ctx.alloc(), maxRequestMessageLength, grpcWebText).decompressor(UnaryServerCall.clientDecompressor((HttpHeaders)clientHeaders, decompressorRegistry));
        this.req = req;
        this.resFuture = Objects.requireNonNull(resFuture, "resFuture");
    }

    public void request(int numMessages) {
    }

    @Override
    public void startDeframing() {
        this.req.aggregate(AggregationOptions.usePooledObjects((ByteBufAllocator)this.ctx.alloc(), (EventExecutor)this.ctx.eventLoop())).handle((aggregatedHttpRequest, cause) -> {
            if (cause != null) {
                this.onError((Throwable)cause);
                return null;
            }
            try {
                this.onRequestMessage(this.requestDeframer.deframe(aggregatedHttpRequest.content()), true);
            }
            catch (Exception ex) {
                this.onError(ex);
            }
            return null;
        });
    }

    public void sendMessage(O message) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doSendMessage(message);
        } else {
            this.ctx.eventLoop().execute(() -> this.doSendMessage(message));
        }
    }

    private void doSendMessage(O message) {
        if (this.isCancelled()) {
            return;
        }
        Preconditions.checkState((this.responseHeaders() != null ? 1 : 0) != 0, (Object)"sendHeaders has not been called");
        Preconditions.checkState((this.responseMessage == null ? 1 : 0) != 0, (Object)"responseMessage is set already");
        Preconditions.checkState((!this.isCloseCalled() ? 1 : 0) != 0, (Object)"call is closed");
        this.responseMessage = message;
    }

    public boolean isReady() {
        return !this.isCloseCalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doClose(Status status, Metadata metadata, boolean completed) {
        ResponseHeaders responseHeaders = this.responseHeaders();
        StatusAndMetadata statusAndMetadata = new StatusAndMetadata(status, metadata);
        try {
            HttpResponse response;
            if (status.isOk()) {
                assert (responseHeaders != null);
                assert (this.responseMessage != null);
                HttpData responseBody = this.toPayload(this.responseMessage);
                HttpObject responseTrailers = this.responseTrailers(this.ctx, status, metadata, false);
                if (responseTrailers instanceof HttpData) {
                    HttpData httpData = HttpMessageAggregator.aggregateData((HttpData)responseBody, (HttpData)((HttpData)responseTrailers), (ByteBufAllocator)this.ctx.alloc());
                    response = HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)httpData);
                } else {
                    response = HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)responseBody, (HttpHeaders)((HttpHeaders)responseTrailers));
                }
            } else {
                ResponseHeadersBuilder trailersBuilder = responseHeaders != null ? responseHeaders.toBuilder() : this.defaultResponseHeaders().toBuilder();
                response = HttpResponse.of((ResponseHeaders)((ResponseHeaders)UnaryServerCall.statusToTrailers(this.ctx, (HttpHeadersBuilder)trailersBuilder, status, metadata)));
            }
            this.ctx.logBuilder().responseContent((Object)GrpcLogUtil.rpcResponse(statusAndMetadata, this.responseMessage), null);
            this.resFuture.complete(response);
        }
        catch (Exception ex) {
            this.resFuture.completeExceptionally(ex);
        }
        finally {
            this.closeListener(statusAndMetadata, completed, false);
        }
    }

    @Override
    @Nullable
    protected O firstResponse() {
        return this.responseMessage;
    }
}

