/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.google.rpc.Status;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.grpc.GrpcStatusFunction;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import io.grpc.Metadata;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.Objects;

@UnstableApi
public interface GoogleGrpcStatusFunction
extends GrpcStatusFunction {
    @Override
    @Nullable
    default public io.grpc.Status apply(RequestContext ctx, Throwable throwable, Metadata metadata) {
        Throwable cause = Exceptions.peel((Throwable)Objects.requireNonNull(throwable, "throwable"));
        if (cause instanceof StatusRuntimeException) {
            return ((StatusRuntimeException)cause).getStatus();
        }
        if (cause instanceof StatusException) {
            return ((StatusException)cause).getStatus();
        }
        Status statusProto = this.applyStatusProto(ctx, cause, metadata);
        if (statusProto == null) {
            return null;
        }
        io.grpc.Status status = io.grpc.Status.fromCodeValue((int)statusProto.getCode()).withDescription(statusProto.getMessage());
        metadata.discardAll(MetadataUtil.GRPC_STATUS_DETAILS_BIN_KEY);
        metadata.put(MetadataUtil.GRPC_STATUS_DETAILS_BIN_KEY, (Object)statusProto);
        return status;
    }

    public @Nullable Status applyStatusProto(RequestContext var1, Throwable var2, Metadata var3);
}

