/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import com.linecorp.armeria.internal.server.annotation.DecoratorAnnotationUtil;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.CaseFormat;
import com.linecorp.armeria.internal.shaded.guava.base.Converter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.grpc.InternalReflectionUtils;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

final class HandlerRegistry {
    private static final Converter<String, String> methodNameConverter = CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL);
    private final List<ServerServiceDefinition> services;
    private final Map<String, ServerMethodDefinition<?, ?>> methods;
    private final Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute;
    private final Map<MethodDescriptor<?, ?>, String> simpleMethodNames;
    private final Map<ServerMethodDefinition<?, ?>, List<DecoratorAnnotationUtil.DecoratorAndOrder>> annotationDecorators;
    private final Map<ServerMethodDefinition<?, ?>, List<? extends Function<? super HttpService, ? extends HttpService>>> additionalDecorators;
    private final Set<ServerMethodDefinition<?, ?>> blockingMethods;

    private HandlerRegistry(List<ServerServiceDefinition> services, Map<String, ServerMethodDefinition<?, ?>> methods, Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute, Map<MethodDescriptor<?, ?>, String> simpleMethodNames, Map<ServerMethodDefinition<?, ?>, List<DecoratorAnnotationUtil.DecoratorAndOrder>> annotationDecorators, Map<ServerMethodDefinition<?, ?>, List<? extends Function<? super HttpService, ? extends HttpService>>> additionalDecorators, Set<ServerMethodDefinition<?, ?>> blockingMethods) {
        this.services = Objects.requireNonNull(services, "services");
        this.methods = Objects.requireNonNull(methods, "methods");
        this.methodsByRoute = Objects.requireNonNull(methodsByRoute, "methodsByRoute");
        this.simpleMethodNames = Objects.requireNonNull(simpleMethodNames, "simpleMethodNames");
        this.annotationDecorators = Objects.requireNonNull(annotationDecorators, "annotationDecorators");
        this.additionalDecorators = Objects.requireNonNull(additionalDecorators, "additionalDecorators");
        this.blockingMethods = Objects.requireNonNull(blockingMethods, "blockingMethods");
    }

    @Nullable
    ServerMethodDefinition<?, ?> lookupMethod(String methodName) {
        return this.methods.get(methodName);
    }

    String simpleMethodName(MethodDescriptor<?, ?> methodName) {
        return this.simpleMethodNames.get(methodName);
    }

    List<ServerServiceDefinition> services() {
        return this.services;
    }

    Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.methods;
    }

    Map<Route, ServerMethodDefinition<?, ?>> methodsByRoute() {
        return this.methodsByRoute;
    }

    @VisibleForTesting
    Map<ServerMethodDefinition<?, ?>, List<DecoratorAnnotationUtil.DecoratorAndOrder>> annotationDecorators() {
        return this.annotationDecorators;
    }

    boolean containsDecorators() {
        return !this.annotationDecorators.isEmpty() || !this.additionalDecorators.isEmpty();
    }

    boolean needToUseBlockingTaskExecutor(ServerMethodDefinition<?, ?> methodDef) {
        return this.blockingMethods.contains(methodDef);
    }

    Map<ServerMethodDefinition<?, ?>, HttpService> applyDecorators(HttpService delegate, DependencyInjector dependencyInjector) {
        HashMap decorated = new HashMap();
        for (Map.Entry<ServerMethodDefinition<?, ?>, List<DecoratorAnnotationUtil.DecoratorAndOrder>> entry : this.annotationDecorators.entrySet()) {
            List decorators = (List)entry.getValue().stream().map(decoratorAndOrder -> decoratorAndOrder.decorator(dependencyInjector)).collect(ImmutableList.toImmutableList());
            decorated.put(entry.getKey(), HandlerRegistry.applyDecorators(decorators, delegate));
        }
        for (Map.Entry<ServerMethodDefinition<?, ?>, List<Object>> entry : this.additionalDecorators.entrySet()) {
            HttpService service = decorated.getOrDefault(entry.getKey(), delegate);
            decorated.put(entry.getKey(), HandlerRegistry.applyDecorators((Iterable<? extends Function<? super HttpService, ? extends HttpService>>)entry.getValue(), service));
        }
        return ImmutableMap.copyOf(decorated);
    }

    private static HttpService applyDecorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators, HttpService delegate) {
        Function<Object, Object> decorator = Function.identity();
        for (Function<? super HttpService, ? extends HttpService> function : decorators) {
            decorator = decorator.compose(function);
        }
        return (HttpService)decorator.apply(delegate);
    }

    static final class Entry {
        private final String path;
        private final ServerServiceDefinition service;
        @Nullable
        private final MethodDescriptor<?, ?> method;
        @Nullable
        private final Class<?> type;
        private final List<? extends Function<? super HttpService, ? extends HttpService>> additionalDecorators;

        Entry(String path, ServerServiceDefinition service, @Nullable MethodDescriptor<?, ?> method, @Nullable Class<?> type, List<? extends Function<? super HttpService, ? extends HttpService>> additionalDecorators) {
            this.path = path;
            this.service = service;
            this.method = method;
            this.type = type;
            this.additionalDecorators = additionalDecorators;
        }

        String path() {
            return this.path;
        }

        ServerServiceDefinition service() {
            return this.service;
        }

        @Nullable
        MethodDescriptor<?, ?> method() {
            return this.method;
        }

        @Nullable
        Class<?> type() {
            return this.type;
        }

        List<? extends Function<? super HttpService, ? extends HttpService>> additionalDecorators() {
            return this.additionalDecorators;
        }
    }

    static final class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();

        Builder() {
        }

        Builder addService(ServerServiceDefinition service, @Nullable Class<?> type, List<? extends Function<? super HttpService, ? extends HttpService>> additionalDecorators) {
            Objects.requireNonNull(service, "service");
            Objects.requireNonNull(additionalDecorators, "additionalDecorators");
            this.entries.add(new Entry(service.getServiceDescriptor().getName(), service, null, type, additionalDecorators));
            return this;
        }

        Builder addService(String path, ServerServiceDefinition service, @Nullable MethodDescriptor<?, ?> methodDescriptor, @Nullable Class<?> type, List<? extends Function<? super HttpService, ? extends HttpService>> additionalDecorators) {
            Objects.requireNonNull(path, "path");
            Objects.requireNonNull(service, "service");
            Objects.requireNonNull(additionalDecorators, "additionalDecorators");
            this.entries.add(new Entry(Builder.normalizePath(path, methodDescriptor == null), service, methodDescriptor, type, additionalDecorators));
            return this;
        }

        private static String normalizePath(String path, boolean isServicePath) {
            int lastCharIndex;
            if (path.isEmpty()) {
                return path;
            }
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.isEmpty()) {
                return path;
            }
            if (isServicePath && path.charAt(lastCharIndex = path.length() - 1) == '/') {
                path = path.substring(0, lastCharIndex);
            }
            return path;
        }

        private static boolean needToUseBlockingTaskExecutor(Class<?> clazz, Method method) {
            return AnnotationUtil.findFirst((AnnotatedElement)method, Blocking.class) != null || AnnotationUtil.findFirst(clazz, Blocking.class) != null;
        }

        List<Entry> entries() {
            return this.entries;
        }

        HandlerRegistry build() {
            ImmutableMap.Builder services = ImmutableMap.builder();
            ImmutableMap.Builder methods = ImmutableMap.builder();
            ImmutableMap.Builder methodsByRoute = ImmutableMap.builder();
            ImmutableMap.Builder bareMethodNames = ImmutableMap.builder();
            ImmutableMap.Builder annotationDecorators = ImmutableMap.builder();
            ImmutableMap.Builder additionalDecoratorsBuilder = ImmutableMap.builder();
            ImmutableSet.Builder blockingMethods = ImmutableSet.builder();
            for (Entry entry : this.entries) {
                String methodName;
                ServerServiceDefinition service = entry.service();
                String path = entry.path();
                services.put((Object)path, (Object)service);
                MethodDescriptor<?, ?> methodDescriptor = entry.method();
                List<? extends Function<? super HttpService, ? extends HttpService>> additionalDecorators = entry.additionalDecorators();
                if (methodDescriptor == null) {
                    Class<?> type = entry.type();
                    HashMap<String, Method> publicMethods = new HashMap<String, Method>();
                    if (type != null) {
                        for (Method method : InternalReflectionUtils.getAllSortedMethods(type, ReflectionUtils.withModifier((int)1))) {
                            methodName = method.getName();
                            if (publicMethods.containsKey(methodName)) continue;
                            publicMethods.put(methodName, method);
                        }
                    }
                    for (ServerMethodDefinition methodDefinition : service.getMethods()) {
                        String methodName2;
                        Method method;
                        MethodDescriptor methodDescriptor0 = methodDefinition.getMethodDescriptor();
                        String bareMethodName = methodDescriptor0.getBareMethodName();
                        assert (bareMethodName != null);
                        String pathWithMethod = path + '/' + bareMethodName;
                        methods.put((Object)pathWithMethod, (Object)methodDefinition);
                        methodsByRoute.put((Object)Route.builder().exact('/' + pathWithMethod).build(), (Object)methodDefinition);
                        bareMethodNames.put((Object)methodDescriptor0, (Object)bareMethodName);
                        if (!additionalDecorators.isEmpty()) {
                            additionalDecoratorsBuilder.put((Object)methodDefinition, additionalDecorators);
                        }
                        if ((method = (Method)publicMethods.get(methodName2 = (String)methodNameConverter.convert((Object)bareMethodName))) == null) continue;
                        assert (type != null);
                        List decoratorAndOrders = DecoratorAnnotationUtil.collectDecorators(type, (Method)method);
                        if (!decoratorAndOrders.isEmpty()) {
                            annotationDecorators.put((Object)methodDefinition, (Object)decoratorAndOrders);
                        }
                        if (!Builder.needToUseBlockingTaskExecutor(type, method)) continue;
                        blockingMethods.add((Object)methodDefinition);
                    }
                    continue;
                }
                ServerMethodDefinition methodDefinition = service.getMethods().stream().filter(method0 -> method0.getMethodDescriptor() == methodDescriptor).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to retrieve " + methodDescriptor + " in " + service));
                methods.put((Object)path, (Object)methodDefinition);
                additionalDecoratorsBuilder.put((Object)methodDefinition, additionalDecorators);
                methodsByRoute.put((Object)Route.builder().exact('/' + path).build(), (Object)methodDefinition);
                MethodDescriptor methodDescriptor0 = methodDefinition.getMethodDescriptor();
                String bareMethodName = methodDescriptor0.getBareMethodName();
                assert (bareMethodName != null);
                bareMethodNames.put((Object)methodDescriptor0, (Object)bareMethodName);
                Class<?> type = entry.type();
                if (type == null) continue;
                methodName = (String)methodNameConverter.convert((Object)bareMethodName);
                Optional<Method> method = InternalReflectionUtils.getAllSortedMethods(type, ReflectionUtils.withModifier((int)1)).stream().filter(m -> methodName.equals(m.getName())).findFirst();
                if (!method.isPresent()) continue;
                Method method02 = method.get();
                List decoratorAndOrders = DecoratorAnnotationUtil.collectDecorators(type, (Method)method02);
                if (!decoratorAndOrders.isEmpty()) {
                    annotationDecorators.put((Object)methodDefinition, (Object)decoratorAndOrders);
                }
                if (!Builder.needToUseBlockingTaskExecutor(type, method02)) continue;
                blockingMethods.add((Object)methodDefinition);
            }
            ImmutableMap services0 = services.build();
            return new HandlerRegistry((List)ImmutableList.copyOf(services0.values()), (Map)methods.build(), (Map)methodsByRoute.build(), (Map)bareMethodNames.buildKeepingLast(), (Map)annotationDecorators.build(), (Map)additionalDecoratorsBuilder.build(), (Set)blockingMethods.build());
        }
    }
}

