/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.ArmeriaRequestCoroutineContext;
import com.linecorp.armeria.server.grpc.ServerCallUtil;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.kotlin.CoroutineContextServerInterceptor;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.ExecutorsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArmeriaCoroutineContextInterceptor
extends CoroutineContextServerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ArmeriaCoroutineContextInterceptor.class);
    private static final List<?> COROUTINE_CONTEXT_PROVIDERS;
    @Nullable
    private static final MethodHandle PROVIDE_METHOD;
    private final boolean useBlockingTaskExecutor;

    ArmeriaCoroutineContextInterceptor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
    }

    public CoroutineContext coroutineContext(ServerCall<?, ?> serverCall, Metadata metadata) {
        ServiceRequestContext ctx = ServerCallUtil.findRequestContext(serverCall);
        Preconditions.checkState((ctx != null ? 1 : 0) != 0, (String)"Failed to find the current %s from %s", (Object)ServiceRequestContext.class.getSimpleName(), serverCall);
        ArmeriaRequestCoroutineContext coroutineContext = new ArmeriaRequestCoroutineContext(ctx);
        if (PROVIDE_METHOD != null && !COROUTINE_CONTEXT_PROVIDERS.isEmpty()) {
            for (Object provider : COROUTINE_CONTEXT_PROVIDERS) {
                try {
                    coroutineContext = coroutineContext.plus(PROVIDE_METHOD.invoke(provider, ctx));
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to invoke CoroutineContextProvider#provide()", e);
                }
            }
            return coroutineContext;
        }
        Object executor = this.useBlockingTaskExecutor ? ctx.blockingTaskExecutor().withoutContext() : ctx.eventLoop().withoutContext();
        return ExecutorsKt.from((ExecutorService)executor).plus((CoroutineContext)coroutineContext);
    }

    static {
        ImmutableList providers = ImmutableList.of();
        MethodHandle provideMethod = null;
        try {
            Class<?> clazz = Class.forName(RequestContext.class.getPackage().getName() + ".kotlin.CoroutineContextProvider");
            providers = ImmutableList.copyOf(ServiceLoader.load(clazz, ArmeriaCoroutineContextInterceptor.class.getClassLoader()));
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            MethodType mt = MethodType.methodType(CoroutineContext.class, ServiceRequestContext.class);
            provideMethod = publicLookup.findVirtual(clazz, "provide", mt);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        if (!providers.isEmpty()) {
            logger.debug("Available CoroutineContextProviders: {}", (Object)providers);
        }
        COROUTINE_CONTEXT_PROVIDERS = providers;
        PROVIDE_METHOD = provideMethod;
    }
}

