/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.BadRequest;
import com.google.rpc.DebugInfo;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Help;
import com.google.rpc.LocalizedMessage;
import com.google.rpc.PreconditionFailure;
import com.google.rpc.QuotaFailure;
import com.google.rpc.RequestInfo;
import com.google.rpc.ResourceInfo;
import com.google.rpc.RetryInfo;
import com.google.rpc.Status;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcStatusMappingFunction;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import org.curioswitch.common.protobuf.json.MessageMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnframedGrpcErrorHandlers {
    private static final Logger logger = LoggerFactory.getLogger(UnframedGrpcErrorHandlers.class);
    private static final MessageMarshaller ERROR_DETAILS_MARSHALLER = MessageMarshaller.builder().omittingInsignificantWhitespace(true).register((Message)RetryInfo.getDefaultInstance()).register((Message)ErrorInfo.getDefaultInstance()).register((Message)QuotaFailure.getDefaultInstance()).register((Message)DebugInfo.getDefaultInstance()).register((Message)PreconditionFailure.getDefaultInstance()).register((Message)BadRequest.getDefaultInstance()).register((Message)RequestInfo.getDefaultInstance()).register((Message)ResourceInfo.getDefaultInstance()).register((Message)Help.getDefaultInstance()).register((Message)LocalizedMessage.getDefaultInstance()).build();
    private static final ObjectMapper mapper = JacksonUtil.newDefaultObjectMapper();

    static UnframedGrpcErrorHandler of(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        UnframedGrpcStatusMappingFunction mappingFunction = UnframedGrpcErrorHandlers.withDefault(statusMappingFunction);
        return (ctx, status, response) -> {
            MediaType grpcMediaType = response.contentType();
            if (grpcMediaType != null && grpcMediaType.isJson()) {
                return UnframedGrpcErrorHandlers.ofJson(mappingFunction).handle(ctx, status, response);
            }
            return UnframedGrpcErrorHandlers.ofPlaintext(mappingFunction).handle(ctx, status, response);
        };
    }

    static UnframedGrpcErrorHandler ofJson(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        UnframedGrpcStatusMappingFunction mappingFunction = UnframedGrpcErrorHandlers.withDefault(statusMappingFunction);
        return (ctx, status, response) -> {
            ByteBuf buffer = ctx.alloc().buffer();
            Status.Code grpcCode = status.getCode();
            String grpcMessage = status.getDescription();
            Throwable cause = UnframedGrpcErrorHandlers.responseCause(ctx);
            HttpStatus httpStatus = mappingFunction.apply(ctx, status, cause);
            HttpHeaders trailers = !response.trailers().isEmpty() ? response.trailers() : response.headers();
            String grpcStatusDetailsBin = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS_DETAILS_BIN);
            ResponseHeaders responseHeaders = ResponseHeaders.builder((HttpStatus)httpStatus).contentType(MediaType.JSON_UTF_8).addInt((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcCode.value()).build();
            boolean success = false;
            try (ByteBufOutputStream outputStream = new ByteBufOutputStream(buffer);
                 JsonGenerator jsonGenerator = mapper.createGenerator((OutputStream)outputStream);){
                jsonGenerator.writeStartObject();
                jsonGenerator.writeNumberField("code", grpcCode.value());
                jsonGenerator.writeStringField("grpc-code", grpcCode.name());
                if (grpcMessage != null) {
                    jsonGenerator.writeStringField("message", grpcMessage);
                }
                if (cause != null && ctx.config().verboseResponses()) {
                    jsonGenerator.writeStringField("stack-trace", Exceptions.traceText((Throwable)cause));
                }
                if (!Strings.isNullOrEmpty((String)grpcStatusDetailsBin)) {
                    Status rpcStatus = null;
                    try {
                        rpcStatus = UnframedGrpcErrorHandlers.decodeGrpcStatusDetailsBin(grpcStatusDetailsBin);
                    }
                    catch (InvalidProtocolBufferException e) {
                        logger.warn("Unexpected exception while decoding grpc-status-details-bin: {}", (Object)grpcStatusDetailsBin, (Object)e);
                    }
                    if (rpcStatus != null) {
                        jsonGenerator.writeFieldName("details");
                        UnframedGrpcErrorHandlers.writeErrorDetails(rpcStatus.getDetailsList(), jsonGenerator);
                    }
                }
                jsonGenerator.writeEndObject();
                jsonGenerator.flush();
                success = true;
            }
            catch (IOException e) {
                logger.warn("Unexpected exception while generating a JSON response", (Throwable)e);
            }
            finally {
                if (!success) {
                    buffer.release();
                }
            }
            if (success) {
                return HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)HttpData.wrap((ByteBuf)buffer));
            }
            return HttpResponse.of((ResponseHeaders)responseHeaders);
        };
    }

    static UnframedGrpcErrorHandler ofPlaintext(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        UnframedGrpcStatusMappingFunction mappingFunction = UnframedGrpcErrorHandlers.withDefault(statusMappingFunction);
        return (ctx, status, response) -> {
            HttpData content;
            Status.Code grpcCode = status.getCode();
            String grpcMessage = status.getDescription();
            Throwable cause = UnframedGrpcErrorHandlers.responseCause(ctx);
            HttpStatus httpStatus = mappingFunction.apply(ctx, status, cause);
            ResponseHeaders responseHeaders = ResponseHeaders.builder((HttpStatus)httpStatus).contentType(MediaType.PLAIN_TEXT_UTF_8).addInt((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcCode.value()).build();
            try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
                StringBuilder msg = ttl.stringBuilder();
                msg.append("grpc-code: ").append(grpcCode.name());
                if (grpcMessage != null) {
                    msg.append(", ").append(grpcMessage);
                }
                if (cause != null && ctx.config().verboseResponses()) {
                    msg.append("\nstack-trace:\n").append(Exceptions.traceText((Throwable)cause));
                }
                content = HttpData.ofUtf8((CharSequence)msg);
            }
            return HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)content);
        };
    }

    private static UnframedGrpcStatusMappingFunction withDefault(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        Objects.requireNonNull(statusMappingFunction, "statusMappingFunction");
        if (statusMappingFunction == UnframedGrpcStatusMappingFunction.of()) {
            return statusMappingFunction;
        }
        return statusMappingFunction.orElse(UnframedGrpcStatusMappingFunction.of());
    }

    @VisibleForTesting
    static void writeErrorDetails(List<Any> details, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartArray();
        for (Any detail : details) {
            try {
                ERROR_DETAILS_MARSHALLER.writeValue((Message)detail, jsonGenerator);
            }
            catch (IOException e) {
                logger.warn("Unexpected exception while writing an error detail to JSON. detail: {}", (Object)detail, (Object)e);
            }
        }
        jsonGenerator.writeEndArray();
    }

    static Status decodeGrpcStatusDetailsBin(String grpcStatusDetailsBin) throws InvalidProtocolBufferException {
        byte[] result = Base64.getDecoder().decode(grpcStatusDetailsBin);
        return Status.parseFrom((byte[])result);
    }

    @Nullable
    private static Throwable responseCause(ServiceRequestContext ctx) {
        RequestLogAccess log = ctx.log();
        if (log.isAvailable(RequestLogProperty.RESPONSE_CAUSE)) {
            return log.partial().responseCause();
        }
        return null;
    }

    private UnframedGrpcErrorHandlers() {
    }
}

