/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.google.protobuf.Message;
import com.google.rpc.Status;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.internal.shaded.guava.base.CharMatcher;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.io.BaseEncoding;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.protobuf.ProtoUtils;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataUtil {
    public static final Metadata.Key<Status> GRPC_STATUS_DETAILS_BIN_KEY = Metadata.Key.of((String)GrpcHeaderNames.GRPC_STATUS_DETAILS_BIN.toString(), (Metadata.BinaryMarshaller)ProtoUtils.metadataMarshaller((Message)Status.getDefaultInstance()));
    private static final Logger logger = LoggerFactory.getLogger(MetadataUtil.class);
    private static final CharMatcher COMMA_MATCHER = CharMatcher.is((char)',');
    private static final BaseEncoding BASE64_ENCODING_OMIT_PADDING = BaseEncoding.base64().omitPadding();
    private static final Set<AsciiString> STRIPPED_HEADERS = ImmutableSet.of((Object)HttpHeaderNames.STATUS, (Object)GrpcHeaderNames.GRPC_MESSAGE, (Object)GrpcHeaderNames.GRPC_STATUS, (Object)GrpcHeaderNames.ARMERIA_GRPC_THROWABLEPROTO_BIN);

    public static void fillHeaders(Metadata metadata, HttpHeadersBuilder builder) {
        if (InternalMetadata.headerCount((Metadata)metadata) == 0) {
            return;
        }
        byte[][] serializedMetadata = InternalMetadata.serialize((Metadata)metadata);
        assert (serializedMetadata.length % 2 == 0);
        for (int i = 0; i < serializedMetadata.length; i += 2) {
            String value;
            AsciiString name = new AsciiString(serializedMetadata[i], false);
            if (STRIPPED_HEADERS.contains(name)) continue;
            byte[] valueBytes = serializedMetadata[i + 1];
            if (MetadataUtil.isBinary(name)) {
                value = BASE64_ENCODING_OMIT_PADDING.encode(valueBytes);
            } else if (MetadataUtil.isGrpcAscii(valueBytes)) {
                value = new String(valueBytes, StandardCharsets.US_ASCII);
            } else {
                logger.warn("Metadata name=" + name + ", value=" + Arrays.toString(valueBytes) + " contains invalid ASCII characters, skipping.");
                continue;
            }
            builder.add((CharSequence)name, value);
        }
    }

    public static Metadata copyFromHeaders(HttpHeaders headers) {
        if (headers.isEmpty()) {
            return new Metadata();
        }
        int numHeaders = 0;
        for (Map.Entry entry : headers) {
            AsciiString name = (AsciiString)entry.getKey();
            String value = (String)entry.getValue();
            if (STRIPPED_HEADERS.contains(name)) continue;
            if (MetadataUtil.isBinary(name)) {
                numHeaders += COMMA_MATCHER.countIn((CharSequence)value) + 1;
                continue;
            }
            ++numHeaders;
        }
        byte[][] metadata = new byte[numHeaders * 2][];
        int i = 0;
        for (Map.Entry entry : headers) {
            byte[] nameBytes;
            AsciiString name = (AsciiString)entry.getKey();
            String value = (String)entry.getValue();
            if (STRIPPED_HEADERS.contains(name)) continue;
            byte[] byArray = nameBytes = name.isEntireArrayUsed() ? name.array() : name.toByteArray();
            if (MetadataUtil.isBinary(name)) {
                String substring;
                int commaIndex = COMMA_MATCHER.indexIn((CharSequence)value);
                if (commaIndex == -1) {
                    metadata[i++] = nameBytes;
                    metadata[i++] = Base64.getDecoder().decode(value);
                    continue;
                }
                int substringStartIndex = 0;
                while (commaIndex != -1) {
                    substring = value.substring(substringStartIndex, commaIndex);
                    metadata[i++] = nameBytes;
                    metadata[i++] = Base64.getDecoder().decode(substring);
                    substringStartIndex = commaIndex + 1;
                    commaIndex = COMMA_MATCHER.indexIn((CharSequence)value, commaIndex + 1);
                }
                substring = value.substring(substringStartIndex);
                metadata[i++] = nameBytes;
                metadata[i++] = Base64.getDecoder().decode(substring);
                continue;
            }
            metadata[i++] = nameBytes;
            metadata[i++] = value.getBytes(StandardCharsets.UTF_8);
        }
        return InternalMetadata.newMetadata((byte[][])metadata);
    }

    private static boolean isBinary(AsciiString name) {
        return name.endsWith((CharSequence)"-bin");
    }

    private static boolean isGrpcAscii(byte[] value) {
        for (byte b : value) {
            if (b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }

    private MetadataUtil() {
    }
}

