/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.grpc;

import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.ThrowableProto;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.grpc.protocol.GrpcWebTrailers;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.common.grpc.ForwardingCompressor;
import com.linecorp.armeria.internal.common.grpc.ForwardingDecompressor;
import com.linecorp.armeria.internal.common.grpc.GrpcLogUtil;
import com.linecorp.armeria.internal.common.grpc.GrpcMessageMarshaller;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import com.linecorp.armeria.internal.common.grpc.StatusExceptionConverter;
import com.linecorp.armeria.internal.common.grpc.protocol.GrpcTrailersUtil;
import com.linecorp.armeria.internal.server.grpc.ServerStatusAndMetadata;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.unsafe.grpc.GrpcUnsafeBufferUtil;
import io.grpc.Codec;
import io.grpc.Compressor;
import io.grpc.CompressorRegistry;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.InternalMetadata;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoop;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerCall<I, O>
extends ServerCall<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServerCall.class);
    private static final Splitter ACCEPT_ENCODING_SPLITTER = Splitter.on((char)',').trimResults();
    private static final String GRPC_STATUS_CODE_INTERNAL = String.valueOf(Status.Code.INTERNAL.value());
    private final MethodDescriptor<I, O> method;
    private final String simpleMethodName;
    private final HttpRequest req;
    private final ArmeriaMessageFramer responseFramer;
    private final HttpResponse res;
    private final CompressorRegistry compressorRegistry;
    private final ServiceRequestContext ctx;
    private final SerializationFormat serializationFormat;
    private final GrpcMessageMarshaller<I, O> marshaller;
    private final boolean unsafeWrapRequestBuffers;
    private final String clientAcceptEncoding;
    private final boolean autoCompression;
    @Nullable
    private final Executor blockingExecutor;
    private final GrpcExceptionHandlerFunction exceptionHandler;
    @Nullable
    private ServerCall.Listener<I> listener;
    private boolean messageCompression = true;
    private final ResponseHeaders defaultResponseHeaders;
    @Nullable
    private ResponseHeaders responseHeaders;
    @Nullable
    private Compressor compressor;
    private boolean messageReceived;
    private volatile boolean cancelled;
    private volatile boolean clientStreamClosed;
    private volatile boolean listenerClosed;
    private boolean closeCalled;

    protected AbstractServerCall(HttpRequest req, MethodDescriptor<I, O> method, String simpleMethodName, CompressorRegistry compressorRegistry, DecompressorRegistry decompressorRegistry, HttpResponse res, int maxResponseMessageLength, ServiceRequestContext ctx, SerializationFormat serializationFormat, @Nullable GrpcJsonMarshaller jsonMarshaller, boolean unsafeWrapRequestBuffers, ResponseHeaders defaultHeaders, GrpcExceptionHandlerFunction exceptionHandler, @Nullable Executor blockingExecutor, boolean autoCompression, boolean useMethodMarshaller) {
        Objects.requireNonNull(req, "req");
        this.method = Objects.requireNonNull(method, "method");
        this.simpleMethodName = Objects.requireNonNull(simpleMethodName, "simpleMethodName");
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.serializationFormat = Objects.requireNonNull(serializationFormat, "serializationFormat");
        boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(serializationFormat);
        Objects.requireNonNull(decompressorRegistry, "decompressorRegistry");
        ByteBufAllocator alloc = ctx.alloc();
        this.req = req;
        this.responseFramer = new ArmeriaMessageFramer(alloc, maxResponseMessageLength, grpcWebText);
        this.res = Objects.requireNonNull(res, "res");
        this.compressorRegistry = Objects.requireNonNull(compressorRegistry, "compressorRegistry");
        this.clientAcceptEncoding = req.headers().get((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING, "");
        this.autoCompression = autoCompression;
        this.marshaller = new GrpcMessageMarshaller<I, O>(alloc, serializationFormat, method, jsonMarshaller, unsafeWrapRequestBuffers, useMethodMarshaller);
        this.unsafeWrapRequestBuffers = unsafeWrapRequestBuffers;
        this.blockingExecutor = blockingExecutor;
        this.defaultResponseHeaders = defaultHeaders;
        this.exceptionHandler = exceptionHandler;
        res.whenComplete().handle((unused, t) -> {
            ContextAwareEventLoop eventLoop = ctx.eventLoop();
            if (eventLoop.inEventLoop()) {
                this.maybeCancel();
            } else {
                eventLoop.execute(this::maybeCancel);
            }
            return null;
        });
    }

    protected final ResponseHeaders defaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    @Nullable
    protected abstract O firstResponse();

    protected final void maybeCancel() {
        if (!this.closeCalled) {
            this.cancelled = true;
            try (SafeCloseable ignore = this.ctx.push();){
                this.close(new ServerStatusAndMetadata(Status.CANCELLED, new Metadata(), true, true));
            }
        }
    }

    public final void close(Throwable exception) {
        this.close(exception, false);
    }

    public final void close(Throwable exception, boolean cancelled) {
        exception = Exceptions.peel((Throwable)exception);
        Metadata metadata = AbstractServerCall.generateMetadataFromThrowable(exception);
        Status status = this.exceptionHandler.apply((RequestContext)this.ctx, exception, metadata);
        this.close(new ServerStatusAndMetadata(status, metadata, false, cancelled), exception);
    }

    public final void close(Status status, Metadata metadata) {
        if (status.getCause() == null) {
            this.close(new ServerStatusAndMetadata(status, metadata, false));
            return;
        }
        Status newStatus = this.exceptionHandler.apply((RequestContext)this.ctx, status.getCause(), metadata);
        assert (newStatus != null);
        if (status.getDescription() != null) {
            newStatus = newStatus.withDescription(status.getDescription());
        }
        ServerStatusAndMetadata statusAndMetadata = new ServerStatusAndMetadata(newStatus, metadata, false);
        this.close(statusAndMetadata);
    }

    public final void close(ServerStatusAndMetadata statusAndMetadata) {
        this.close(statusAndMetadata, null);
    }

    private void close(ServerStatusAndMetadata statusAndMetadata, @Nullable Throwable exception) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doClose(statusAndMetadata, exception);
        } else {
            this.ctx.eventLoop().execute(() -> this.doClose(statusAndMetadata, exception));
        }
    }

    private void doClose(ServerStatusAndMetadata statusAndMetadata, @Nullable Throwable exception) {
        this.maybeLogFailedRequestContent(exception);
        Status status = statusAndMetadata.status();
        Metadata metadata = statusAndMetadata.metadata();
        if (this.isCancelled()) {
            statusAndMetadata.shouldCancel();
            statusAndMetadata.setResponseContent(true);
            this.closeListener(statusAndMetadata);
            return;
        }
        if (status.getCode() == Status.Code.CANCELLED && status.getCause() instanceof ClosedStreamException) {
            statusAndMetadata.shouldCancel();
            statusAndMetadata.setResponseContent(true);
            this.closeListener(statusAndMetadata);
            return;
        }
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (String)"call already closed. status: %s, exception: %s", (Object)status, (Object)exception);
        this.closeCalled = true;
        if (status.isOk() && this.method.getType().serverSendsOneMessage() && this.firstResponse() == null) {
            String description = "Completed without a response";
            logger.warn("{} {} status: {}, metadata: {}", new Object[]{this.ctx, "Completed without a response", status, metadata});
            status = Status.CANCELLED.withDescription("Completed without a response");
            statusAndMetadata = statusAndMetadata.withStatus(status);
            statusAndMetadata.shouldCancel();
        }
        this.doClose(statusAndMetadata);
    }

    protected abstract void doClose(ServerStatusAndMetadata var1);

    protected final void closeListener(ServerStatusAndMetadata statusAndMetadata) {
        boolean setResponseContent = statusAndMetadata.setResponseContent();
        boolean cancelled = statusAndMetadata.isShouldCancel();
        if (!this.listenerClosed) {
            this.listenerClosed = true;
            if (!this.ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
                this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method, this.simpleMethodName), null);
            }
            if (setResponseContent) {
                this.ctx.logBuilder().responseContent((Object)GrpcLogUtil.rpcResponse(statusAndMetadata, this.firstResponse()), null);
            }
            if (!this.clientStreamClosed) {
                this.clientStreamClosed = true;
                if (statusAndMetadata.status().isOk()) {
                    this.req.abort();
                } else {
                    this.req.abort((Throwable)statusAndMetadata.asRuntimeException());
                }
            }
            if (!cancelled) {
                if (this.blockingExecutor != null) {
                    this.blockingExecutor.execute(this::invokeOnComplete);
                } else {
                    this.invokeOnComplete();
                }
            } else {
                this.cancelled = true;
                if (this.blockingExecutor != null) {
                    this.blockingExecutor.execute(this::invokeOnCancel);
                } else {
                    this.invokeOnCancel();
                }
                if (!this.closeCalled) {
                    this.res.abort((Throwable)statusAndMetadata.asRuntimeException());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRequestMessage(DeframedMessage message, boolean endOfStream) {
        try {
            ByteBuf buf = message.buf();
            boolean success = false;
            try {
                if (this.messageReceived && this.method.getType() == MethodDescriptor.MethodType.UNARY) {
                    Status status = Status.INTERNAL.withDescription("More than one request messages for unary call or server streaming call");
                    this.closeListener(new ServerStatusAndMetadata(status, new Metadata(), true, true));
                    return;
                }
                this.messageReceived = true;
                if (this.closeCalled) {
                    return;
                }
                success = true;
            }
            finally {
                if (!success) {
                    message.close();
                }
            }
            boolean grpcWebText = GrpcSerializationFormats.isGrpcWebText(this.serializationFormat);
            I request = this.marshaller.deserializeRequest(message, grpcWebText);
            this.maybeLogRequestContent(request);
            if (this.unsafeWrapRequestBuffers && buf != null && !grpcWebText) {
                GrpcUnsafeBufferUtil.storeBuffer(buf, request, (RequestContext)this.ctx);
            }
            if (this.blockingExecutor != null) {
                this.blockingExecutor.execute(() -> this.invokeOnMessage(request, endOfStream));
            } else {
                this.invokeOnMessage(request, endOfStream);
            }
        }
        catch (Throwable cause) {
            this.close(cause, true);
        }
    }

    protected final void onRequestComplete() {
        this.clientStreamClosed = true;
        if (!this.closeCalled) {
            this.maybeLogRequestContent(null);
            if (this.blockingExecutor != null) {
                this.blockingExecutor.execute(this::invokeHalfClose);
            } else {
                this.invokeHalfClose();
            }
        }
    }

    protected final void invokeOnReady() {
        try {
            if (this.listener != null) {
                this.listener.onReady();
            }
        }
        catch (Throwable t) {
            this.close(t);
        }
    }

    private void invokeOnMessage(I request, boolean halfClose) {
        try (SafeCloseable ignored = this.ctx.push();){
            assert (this.listener != null);
            this.listener.onMessage(request);
            if (halfClose) {
                this.listener.onHalfClose();
            }
        }
        catch (Throwable cause) {
            this.close(cause);
        }
    }

    protected final void invokeHalfClose() {
        try (SafeCloseable ignored = this.ctx.push();){
            assert (this.listener != null);
            this.listener.onHalfClose();
        }
        catch (Throwable t) {
            this.close(t);
        }
    }

    private void invokeOnComplete() {
        try (SafeCloseable ignored = this.ctx.push();){
            if (this.listener != null) {
                this.listener.onComplete();
            }
        }
        catch (Throwable t) {
            logger.warn("Error in gRPC onComplete handler.", t);
        }
    }

    private void invokeOnCancel() {
        block9: {
            try (SafeCloseable ignored = this.ctx.push();){
                if (this.listener != null) {
                    this.listener.onCancel();
                }
            }
            catch (Throwable t) {
                if (this.closeCalled) break block9;
                this.close(t);
            }
        }
    }

    protected void onError(Throwable t) {
        if (!this.closeCalled && !(t instanceof AbortedStreamException)) {
            this.close(t, true);
        }
    }

    public final void setListener(ServerCall.Listener<I> listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"listener already set");
        this.listener = Objects.requireNonNull(listener, "listener");
        this.invokeOnReady();
    }

    public abstract void startDeframing();

    @Nullable
    protected final ResponseHeaders responseHeaders() {
        return this.responseHeaders;
    }

    public void sendHeaders(Metadata metadata) {
        if (this.ctx.eventLoop().inEventLoop()) {
            this.doSendHeaders(metadata);
        } else {
            this.ctx.eventLoop().execute(() -> this.doSendHeaders(metadata));
        }
    }

    private void doSendHeaders(Metadata metadata) {
        if (this.isCancelled()) {
            return;
        }
        Preconditions.checkState((this.responseHeaders == null ? 1 : 0) != 0, (Object)"sendHeaders already called");
        Preconditions.checkState((!this.closeCalled ? 1 : 0) != 0, (Object)"call is closed");
        Compressor oldCompressor = this.compressor;
        if (this.messageCompression && !this.clientAcceptEncoding.isEmpty()) {
            List acceptedEncodings = ACCEPT_ENCODING_SPLITTER.splitToList((CharSequence)this.clientAcceptEncoding);
            if (this.compressor != null) {
                if (!acceptedEncodings.contains(this.compressor.getMessageEncoding())) {
                    this.compressor = Codec.Identity.NONE;
                }
            } else if (this.autoCompression) {
                for (String encoding : acceptedEncodings) {
                    Compressor compressor0 = this.compressorRegistry.lookupCompressor(encoding);
                    if (compressor0 == null) continue;
                    this.compressor = compressor0;
                    break;
                }
            }
        } else {
            this.compressor = Codec.Identity.NONE;
        }
        if (this.compressor == null) {
            this.compressor = Codec.Identity.NONE;
        }
        if (oldCompressor != this.compressor) {
            this.responseFramer.setCompressor(ForwardingCompressor.forGrpc(this.compressor));
        }
        ResponseHeaders headers = this.defaultResponseHeaders;
        if (this.compressor != Codec.Identity.NONE || InternalMetadata.headerCount((Metadata)metadata) > 0) {
            headers = headers.withMutations(builder -> {
                if (this.compressor != Codec.Identity.NONE) {
                    builder.set((CharSequence)GrpcHeaderNames.GRPC_ENCODING, this.compressor.getMessageEncoding());
                }
                MetadataUtil.fillHeaders(metadata, builder);
                if (!this.method.getType().serverSendsOneMessage() && builder.contentLength() > -1L) {
                    builder.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                }
            });
        }
        this.responseHeaders = headers;
    }

    protected final HttpData toPayload(O message) throws IOException {
        return this.responseFramer.writePayload(this.marshaller.serializeResponse(message));
    }

    protected final HttpObject responseTrailers(ServiceRequestContext ctx, Status status, Metadata metadata, boolean trailersOnly) {
        HttpHeadersBuilder defaultTrailers = trailersOnly ? this.defaultResponseHeaders.toBuilder() : HttpHeaders.builder();
        HttpHeaders trailers = AbstractServerCall.statusToTrailers(ctx, defaultTrailers, status, metadata);
        if (!trailersOnly && GrpcSerializationFormats.isGrpcWeb(this.serializationFormat)) {
            GrpcWebTrailers.set((RequestContext)ctx, (HttpHeaders)trailers);
            ByteBuf serialized = GrpcTrailersUtil.serializeTrailersAsMessage((ByteBufAllocator)ctx.alloc(), (HttpHeaders)trailers);
            return this.responseFramer.writePayload(serialized, true);
        }
        return trailers;
    }

    public static HttpHeaders statusToTrailers(ServiceRequestContext ctx, HttpHeadersBuilder trailersBuilder, Status status, Metadata metadata) {
        try {
            MetadataUtil.fillHeaders(metadata, trailersBuilder);
        }
        catch (Exception e) {
            logger.warn("{} Failed to serialize metadata; overriding the original status ({}) with INTERNAL:", new Object[]{ctx, status, e});
            return trailersBuilder.set((CharSequence)GrpcHeaderNames.GRPC_STATUS, GRPC_STATUS_CODE_INTERNAL).build();
        }
        GrpcTrailersUtil.addStatusMessageToTrailers((HttpHeadersBuilder)trailersBuilder, (int)status.getCode().value(), (String)status.getDescription(), null);
        if (ctx.config().verboseResponses() && status.getCause() != null) {
            ThrowableProto proto = GrpcStatus.serializeThrowable(status.getCause());
            trailersBuilder.add((CharSequence)GrpcHeaderNames.ARMERIA_GRPC_THROWABLEPROTO_BIN, Base64.getEncoder().encodeToString(proto.toByteArray()));
        }
        HttpHeaders additionalTrailers = ctx.additionalResponseTrailers();
        ctx.mutateAdditionalResponseTrailers(HttpHeadersBuilder::clear);
        trailersBuilder.add((Iterable)additionalTrailers);
        return trailersBuilder.build();
    }

    public final synchronized void setMessageCompression(boolean messageCompression) {
        this.responseFramer.setMessageCompression(messageCompression);
        this.messageCompression = messageCompression;
    }

    public final synchronized void setCompression(String compressorName) {
        Preconditions.checkState((this.responseHeaders == null ? 1 : 0) != 0, (Object)"sendHeaders has been called");
        this.compressor = this.compressorRegistry.lookupCompressor(compressorName);
        Preconditions.checkArgument((this.compressor != null ? 1 : 0) != 0, (String)"Unable to find compressor by name %s", (Object)compressorName);
        this.responseFramer.setCompressor(ForwardingCompressor.forGrpc(this.compressor));
    }

    private static Metadata generateMetadataFromThrowable(Throwable exception) {
        @Nullable Metadata metadata = Status.trailersFromThrowable((Throwable)exception);
        return metadata != null ? metadata : new Metadata();
    }

    @Nullable
    protected static com.linecorp.armeria.common.grpc.protocol.Decompressor clientDecompressor(HttpHeaders headers, DecompressorRegistry registry) {
        String encoding = headers.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING);
        if (encoding == null) {
            return ForwardingDecompressor.forGrpc((Decompressor)Codec.Identity.NONE);
        }
        Decompressor decompressor = registry.lookupDecompressor(encoding);
        if (decompressor != null) {
            return ForwardingDecompressor.forGrpc(decompressor);
        }
        return ForwardingDecompressor.forGrpc((Decompressor)Codec.Identity.NONE);
    }

    private void maybeLogRequestContent(@Nullable Object message) {
        if (!this.ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
            if (message == null) {
                this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method, this.simpleMethodName), null);
            } else {
                this.ctx.logBuilder().requestContent((Object)GrpcLogUtil.rpcRequest(this.method, this.simpleMethodName, message), null);
            }
        }
    }

    private void maybeLogFailedRequestContent(@Nullable Throwable cause) {
        RequestLogBuilder logBuilder = this.ctx.logBuilder();
        if (!this.ctx.log().isAvailable(RequestLogProperty.REQUEST_CONTENT)) {
            logBuilder.requestContent((Object)GrpcLogUtil.rpcRequest(this.method, this.simpleMethodName), null);
        }
        if (cause != null) {
            if (cause instanceof ArmeriaStatusException) {
                cause = StatusExceptionConverter.toGrpc((ArmeriaStatusException)cause);
            }
            logBuilder.endRequest(cause);
        }
    }

    public final boolean isCloseCalled() {
        return this.closeCalled;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Nullable
    public final Executor blockingExecutor() {
        return this.blockingExecutor;
    }

    public final EventLoop eventLoop() {
        return this.ctx.eventLoop();
    }

    public final MethodDescriptor<I, O> getMethodDescriptor() {
        return this.method;
    }

    public final ServiceRequestContext ctx() {
        return this.ctx;
    }

    public final GrpcExceptionHandlerFunction exceptionHandler() {
        return this.exceptionHandler;
    }
}

