/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandler;
import com.linecorp.armeria.server.grpc.UnframedGrpcErrorHandlerUtil;
import com.linecorp.armeria.server.grpc.UnframedGrpcStatusMappingFunction;
import io.grpc.Status;

final class TextUnframedGrpcErrorHandler
implements UnframedGrpcErrorHandler {
    private static final UnframedGrpcStatusMappingFunction DEFAULT_STATUS_MAPPING_FUNCTION = UnframedGrpcStatusMappingFunction.of();
    private static final TextUnframedGrpcErrorHandler DEFAULT = new TextUnframedGrpcErrorHandler(DEFAULT_STATUS_MAPPING_FUNCTION);
    private final UnframedGrpcStatusMappingFunction statusMappingFunction;

    static TextUnframedGrpcErrorHandler of() {
        return DEFAULT;
    }

    static TextUnframedGrpcErrorHandler of(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        if (DEFAULT_STATUS_MAPPING_FUNCTION == statusMappingFunction) {
            return DEFAULT;
        }
        return new TextUnframedGrpcErrorHandler(statusMappingFunction);
    }

    private TextUnframedGrpcErrorHandler(UnframedGrpcStatusMappingFunction statusMappingFunction) {
        this.statusMappingFunction = UnframedGrpcErrorHandlerUtil.withDefault(statusMappingFunction);
    }

    @Override
    public HttpResponse handle(ServiceRequestContext ctx, Status status, AggregatedHttpResponse response) {
        HttpData content;
        Status.Code grpcCode = status.getCode();
        String grpcMessage = status.getDescription();
        Throwable cause = UnframedGrpcErrorHandlerUtil.responseCause(ctx);
        HttpStatus httpStatus = this.statusMappingFunction.apply(ctx, status, cause);
        ResponseHeaders responseHeaders = ResponseHeaders.builder((HttpStatus)httpStatus).contentType(MediaType.PLAIN_TEXT_UTF_8).addInt((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcCode.value()).build();
        try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
            StringBuilder msg = ttl.stringBuilder();
            msg.append("grpc-code: ").append(grpcCode.name());
            if (grpcMessage != null) {
                msg.append(", ").append(grpcMessage);
            }
            if (cause != null && ctx.config().verboseResponses()) {
                msg.append("\nstack-trace:\n").append(Exceptions.traceText((Throwable)cause));
            }
            content = HttpData.ofUtf8((CharSequence)msg);
        }
        return HttpResponse.of((ResponseHeaders)responseHeaders, (HttpData)content);
    }
}

