/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc;

import com.google.protobuf.InvalidProtocolBufferException;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.circuitbreaker.FailFastException;
import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.TimeoutException;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.grpc.Metadata;
import io.grpc.Status;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;

enum DefaultGrpcExceptionHandlerFunction implements GrpcExceptionHandlerFunction
{
    INSTANCE;


    @Override
    public Status apply(RequestContext ctx, Status status, Throwable cause, Metadata metadata) {
        if (status.getCode() != Status.Code.UNKNOWN) {
            return status;
        }
        Status s = Status.fromThrowable((Throwable)cause);
        if (s.getCode() != Status.Code.UNKNOWN) {
            return s;
        }
        if (cause instanceof ClosedSessionException || cause instanceof ClosedChannelException) {
            if (ctx instanceof ServiceRequestContext) {
                return Status.CANCELLED.withCause(cause);
            }
            return s;
        }
        if (cause instanceof ClosedStreamException || cause instanceof RequestTimeoutException) {
            return Status.CANCELLED.withCause(cause);
        }
        if (cause instanceof InvalidProtocolBufferException) {
            return Status.INVALID_ARGUMENT.withCause(cause);
        }
        if (cause instanceof UnprocessedRequestException || cause instanceof IOException || cause instanceof FailFastException) {
            return Status.UNAVAILABLE.withCause(cause);
        }
        if (cause instanceof Http2Exception) {
            if (cause instanceof Http2Exception.StreamException && ((Http2Exception.StreamException)cause).error() == Http2Error.CANCEL) {
                return Status.CANCELLED;
            }
            return Status.INTERNAL.withCause(cause);
        }
        if (cause instanceof TimeoutException) {
            return Status.DEADLINE_EXCEEDED.withCause(cause);
        }
        if (cause instanceof ContentTooLargeException) {
            return Status.RESOURCE_EXHAUSTED.withCause(cause);
        }
        return s;
    }
}

